<h2>Why is this an issue?</h2>
<p>Any variable or function declared in the global scope implicitly becomes attached to the global object (the <code>window</code> object in a browser
environment). To make it explicit this variable or function should be a property of <code>window</code>. When it is meant to be used just locally, it
should be declared with the <code>const</code> or <code>let</code> keywords (since ECMAScript 2015) or within an Immediately-Invoked Function
Expression (IIFE).</p>
<p>This rule should not be activated when modules are used.</p>
<h3>Noncompliant code example</h3>

```js
var myVar = 42;       // Noncompliant
function myFunc() { } // Noncompliant
```
<h3>Compliant solution</h3>

```js
window.myVar = 42;
window.myFunc = function() { };
```
<p>or</p>

```js
let myVar = 42;
let myFunc = function() { }
```
<p>or</p>

```js
// IIFE
(function() {
  var myVar = 42;
  function myFunc() { }
})();
```