<p>Unnecessary calls to <code>.bind()</code> should not be used.</p>
<h2>Why is this an issue?</h2>
<p>The <code>.bind()</code> method allows specifying the value of <code>this</code> and, optionally, the values of some function arguments. However,
if <code>this</code> is not used in the function body, calls to <code>.bind()</code> do nothing and should be removed.</p>
<p>Calling <code>.bind()</code> on arrow functions is a bug because the value of <code>this</code> does not change when <code>.bind()</code> is
applied to arrow functions.</p>
<h2>How to fix it</h2>
<p>Remove calls to <code>.bind()</code> method.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
let x = function fn() {
    return 123;
}.bind({value: 456}); // Noncompliant


let y = (() => this.body).bind(document); // Noncompliant
```
<h4>Compliant solution</h4>

```js
let x = (function callback() {
    return this.body;
}).bind(document); // ok, not an arrow function


let y = (function print(x) {
    console.log(x);
}).bind(this, foo); // ok, binds argument
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_objects/Function/bind"><code>Function.prototype.bind()</code></a>
  </li>
</ul>