<h2>Why is this an issue?</h2>
<p>If JSX special characters (<code>&gt;</code>, <code>}</code>) appear unescaped in the element body, this may be either because you simply forgot to
escape them or because there is a problem with the JSX tag or expression (for example, misplaced or duplicate closing <code>&gt;</code> or
<code>}</code> brackets).</p>

```js
<MyComponent
  name="abc"
  foo="bar">
  x="y"> {/* Noncompliant: closing > should only be on this line */}
  Body Text
</MyComponent>
```
<p>To fix the issue, check the structure of your JSX tag or expression - are the closing brackets correct and in the right place? If the special
character is there on purpose - you need to change it to the appropriate HTML entity.</p>
<ul>
  <li> replace <code>&gt;</code> with <code>&amp;gt;</code> </li>
  <li> replace <code>}</code> with <code>&amp;#125;</code> </li>
</ul>

```js
<MyComponent
  name="abc"
  foo="bar"
  x="y">
  Body Text
</MyComponent>
```
<p>The characters <code>&lt;</code> and <code>{</code> should also be escaped, but they are not checked by this rule because it is a syntax error to
include those tokens inside of a tag.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn#writing-markup-with-jsx">Writing markup with JSX</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Entity">Entity codes</a> </li>
</ul>