<h2>Why is this an issue?</h2>
<p>ARIA properties, also known as "aria-* properties", are special attributes used in HTML to enhance the accessibility of web elements. They provide
additional semantics to help assistive technologies, like screen readers, interpret the element.</p>
<p>Roles, on the other hand, define what an element is or does in the context of a web page. Some elements have explicit roles, which are directly
defined by the developer. For example, a div element might be given a role of "button". Other elements have implicit roles, which are inferred based
on the type of the element. For example, an anchor tag &lt;a href="#" /&gt; has an implicit role of "link".</p>
<p>This rule ensures that the ARIA properties used on an element are ones that are supported by the role of that element. For instance, the ARIA
property <code>aria-required</code> is not supported by the role <code>link</code>. Therefore, using <code>aria-required</code> on an anchor tag would
violate this rule.</p>

```js
<div role="checkbox" aria-chekd={isChecked}>Unchecked</div> {/* Noncompliant: aria-chekd is not supported */}
```
<h2>How to fix it</h2>
<p>Check the spelling of the aria-* attributes and verify that they are actually supported by the element role. Remove non-compatible attributes or
replace them with the correct ones.</p>

```js
<div role="checkbox" aria-checked={isChecked}>Unchecked</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes">ARIA states and properties (Reference)</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>