<p>This rule raises an issue when a private function is never referenced in the code.</p>
<h2>Why is this an issue?</h2>
<p>A function that is never called is dead code, and should be removed. Cleaning out dead code decreases the size of the maintained codebase, making
it easier to understand the program and preventing bugs from being introduced.</p>
<p>This rule detects functions that are never referenced from inside a translation unit, and cannot be referenced from the outside.</p>
<h3>Code examples</h3>
<h3>Noncompliant code example</h3>

```kotlin
class Foo: Serializable {
  private fun unusedMethod() {...}
  private fun writeObject(s: ObjectOutputStream) {...}  // Compliant, relates to the serialization mechanism
  private fun readObject(s: ObjectOutputStream) {...}  // Compliant, relates to the serialization mechanism
}
```
<h3>Compliant solution</h3>

```kotlin
class Foo: Serializable {
  private fun writeObject(s: ObjectOutputStream) {...}  // Compliant, relates to the serialization mechanism
  private fun readObject(s: ObjectOutputStream) {...}  // Compliant, relates to the serialization mechanism
}
```
<h3>Exceptions</h3>
<p>This rule doesn’t raise issues for:</p>
<ul>
  <li> annotated methods </li>
  <li> methods with parameters that are annotated with <code>@javax.enterprise.event.Observes</code> </li>
</ul>
<p>The rule does not take reflection into account, which means that issues will be raised on <code>private</code> methods that are only accessed using
the reflection API.</p>