<h2>Why is this an issue?</h2>
<p>The size of a collection or an array is always greater than or equal to zero. Testing it doesn’t make sense, since the result is always
<code>true</code>.</p>

```kotlin
if (myList.size >= 0) {...} // Noncompliant: always true

boolean result = myArray.size >= 0; // Noncompliant: always true
```
<p>Similarly testing that it is less than zero will always return <code>false</code>.</p>

```kotlin
if (myList.size < 0) {...} // Noncompliant: always false
```
<p>Fix the code to properly check for emptiness if it was the intent, or remove the redundant code to keep the current behavior.</p>