<h2>Why is this an issue?</h2>
<p>A <code>for</code> loop stop condition should test the loop counter against an invariant value (i.e. one that is true at both the beginning and
ending of every loop iteration). Ideally, this means that the stop condition is set to a local variable just before the loop begins.</p>
<p>Stop conditions that are not invariant are slightly less efficient, as well as being difficult to understand and maintain, and likely lead to the
introduction of errors in the future.</p>
<p>This rule tracks three types of non-invariant stop conditions:</p>
<ul>
  <li> When the loop counters are updated in the body of the <code>for</code> loop </li>
  <li> When the stop condition depend upon a method call </li>
  <li> When the stop condition depends on an object property, since such properties could change during the execution of the loop. </li>
</ul>
<h3>Noncompliant code example</h3>

```php
for ($i = 0; $i < 10; $i++) {
  echo $i;
  if(condition) {
    $i = 20;
  }
}
```
<h3>Compliant solution</h3>

```php
for ($i = 0; $i < 10; $i++) {
  echo $i;
}
```