<h2>Why is this an issue?</h2>
<p>There is no good reason to create a new object to not do anything with it. Most of the time, this is due to a missing piece of code and so could
lead to an unexpected behavior in production.</p>
<p>If it was done on purpose because the constructor has side-effects, then that side-effect code should be moved into a separate method and called
directly.</p>
<h3>Noncompliant code example</h3>

```php
if ($x < 0) {
  new foo;  // Noncompliant
}
```
<h3>Compliant solution</h3>

```php
$var = NULL;
if ($x < 0) {
  $var = new foo;
}
```