<h2>Why is this an issue?</h2>
<p>The standard PHPUnit assertion methods such as <code>__assertEquals__</code>, expect the first argument to be the expected value and the second
argument to be the actual value.</p>
<h3>What is the potential impact?</h3>
<p>Having the expected value and the actual value in the wrong order will not alter the outcome of tests, (succeed/fail when it should) but the error
messages will contain misleading information.</p>
<p>This rule raises an issue when the actual argument to an assertions library method is a hard-coded value and the expected argument is not.</p>
<h2>How to fix it</h2>
<p>You should provide the assertion methods with a hard-coded value as the expected value, while the actual value of the assertion should derive from
the portion of code that you want to test.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
self::assertEquals($runner.getExitCode(), 0, "Unexpected exit code"); // Noncompliant; Failed asserting that 0 matches expected 3. Expected :3 Actual :0.
```
<h4>Compliant solution</h4>

```php
self::assertEquals(0, $runner.getExitCode(), "Unexpected exit code");
```