<h2>Why is this an issue?</h2>
<p>When an alternation contains multiple alternatives that consist of a single character, it can be rewritten as a character class. This should be
preferred because it is more efficient.</p>
<h3>Noncompliant code example</h3>

```php
preg_match("/a|b|c/", $str); // Noncompliant
```
<h3>Compliant solution</h3>

```php
preg_match("/[abc]/", $str);
// or
preg_match("/[a-c]/", $str);
```