<h2>Why is this an issue?</h2>
<p>The JavaScript wrapper objects <code>Number</code>, <code>String</code>, and <code>Boolean</code> provide a way to work with their respective
primitive types (<code>number</code>, <code>string</code> and <code>boolean</code>) as objects.</p>
<p>Using wrapper can lead to unexpected behavior due to the differences in how they are compared and used in operations compared to primitive types.
It can also lead to unnecessary memory allocation and slower code execution.</p>

```ts
let x = new Number("0"); // Noncompliant: x is an object, not a primitive
if (x) {
  alert('hi');  // Shows 'hi'.
}
```
<p>Remove the <code>new</code> keyword to get the primitive value instead of a wrapper object.</p>

```ts
let x = Number("0");
if (x) {
  alert('hi');
}
```
<p>However, it is generally recommended to use primitive types directly instead of wrapper objects, which makes the code more consistent and easier to
understand.</p>

```ts
let x = 0;
if (x) {
  alert('hi');
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Primitive">Primitive</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/Number"><code> Number()</code>
  constructor</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/String"><code> String()</code>
  constructor</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/Boolean"><code>Boolean()</code> constructor</a> </li>
</ul>