<h2>Why is this an issue?</h2>
<p>Union types represent a value that can be one of the several types. When a union type is used for a function parameter and it is accepting too many
types, it may indicate the function is having too many responsibilities. Sometimes it’s worth creating a type alias for this union type. In all cases,
the code should be reviewed and refactored to make it more maintainable.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold of 3:</p>

```ts
let x: MyType1 | MyType2 | MyType3 | MyType4; // Noncompliant

function foo(p1: string, p2: MyType1 | MyType2 | MyType3 | MyType4) { // Noncompliant
    // ...
}
```
<h3>Compliant solution</h3>

```ts
type MyUnionType = MyType1 | MyType2 | MyType3 | MyType4; // Compliant, "type" statements are ignored
let x: MyUnionType;

function foo(value: string, padding: MyUnionType) {
    // ...
}
```
<h3>Exceptions</h3>
<p>This rule ignores union types part of <code>type</code> statement:</p>

```ts
type MyUnionType = MyType1 | MyType2 | MyType3 | MyType4;
```
<p>It also ignores union types used with TypeScript utility types:</p>

```ts
type PickedType = Pick<SomeType, 'foo' | 'bar' | 'baz' | 'qux'>;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/utility-types.html">Utility Types</a> </li>
</ul>