<p>In unions and intersections, redundant types should not be used.</p>
<h2>Why is this an issue?</h2>
<p>When defining a union or intersection in TypeScript, it is possible to mistakenly include type constituents that encompass other constituents, that
don’t have any effect, or that are more restrictive. For instance,</p>
<ul>
  <li> The type <code>something</code> in <code>any | something</code> is redundant because <code>any</code> covers all possible types, whatever
  <code>something</code> is. </li>
  <li> The types <code>never</code> in unions like <code>never | something</code> or <code>unknown</code> in intersections like <code>unknown &amp;
  something</code> are effectless. </li>
  <li> More restrictive types in intersections like the literal type <code>1</code> in <code>1 &amp; number</code> reduce the set of possible values
  to specific ones. </li>
</ul>
<p>Eliminating redundant types from a union or intersection type simplifies the code and enhances its readability. Moreover, it provides a clearer
representation of the actual values that a variable can hold.</p>
<h2>How to fix it</h2>
<p>The redundant and overridden types should be removed.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
type UnionWithAny = any | 'redundant'; // Noncompliant
type UnionWithNever = never | 'override'; // Noncompliant
type UnionWithLiteral = number | 1; // Noncompliant

type IntersectionWithAny = any & 'redundant'; // Noncompliant
type IntersectionWithUnknown = string & unknown; // Noncompliant
type IntersectionWithLiteral = string & 'override'; // Noncompliant
```
<h4>Compliant solution</h4>

```ts
type UnionWithAny = any;
type UnionWithNever = never;
type UnionWithLiteral = number;

type IntersectionWithAny = any;
type IntersectionWithUnknown = string;
type IntersectionWithLiteral = 'override';
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/everyday-types.html#union-types">Union Types</a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/objects.html#intersection-types">Intersection Types</a>
  </li>
</ul>