<h2>Why is this an issue?</h2>
<p>The comma operator takes two expressions, executes them from left to right, and returns the result of the second one. The use of this operator is
generally detrimental to the readability and reliability of code, and the same effect can be achieved by other means.</p>

```ts
i = a += 2, a + b;  // Noncompliant: What's the value of i ?
```
<p>Writing each expression on its own line will improve readability and might fix misunderstandings.</p>

```ts
a += 2;
i = a + b; // We probably expected to assign the result of the addition to i, although the previous code wasn't doing it.
```
<h3>Exceptions</h3>
<p>The comma operator is tolerated:</p>
<ul>
  <li> In initializations and increment expressions of <code>for</code> loops. </li>
</ul>

```ts
for (i = 0, j = 5; i < 6; i++, j++) { ... }
```
<ul>
  <li> If the expression sequence is explicitly wrapped in parentheses. </li>
</ul>

```ts
i = (a += 2, a + b); // Compliant by exception
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comma_operator">Comma operator (,)</a>
  </li>
</ul>