#!/bin/bash

#
# Extract health metrics from a single Teamscale instance
#
# Note that the first part (options parsing) is the same for all
# scripts here. This is intended to have self-contained scripts.
#

BASE_URL=
USER=
ACCESS_KEY=
PREFIX=

function print_help {
    cat <<EOF
Options:
  -l, --url URL         The base URL of the Teamscale instance to check
  -u, --user USER       The user name to use for connecting
  -a, --accesskey KEY   The access key used for connecting
  -p, --prefix PREFIX   A prefix to place before the metrics
EOF
}

if [[ $# -lt 1 ]]
then
    print_help
    exit 3
fi

# Option parsing taken from https://stackoverflow.com/a/14203146/1237576
while [[ $# -gt 0 ]]
do
    key="$1"
    case $key in
	-l|--url)
	    BASE_URL="$2"
	    shift
	    ;;
	-u|--user)
	    USER="$2"
	    shift
	    ;;
	-a|--accesskey)
	    ACCESS_KEY="$2"
	    shift
	    ;;
	-p|--prefix)
	    PREFIX="$2"
	    shift
	    ;;
	-h|--help)
	    print_help
	    exit 3
	    ;;
	*)
	    echo Unknown or unsupported option: $key
	    exit 3
	    ;;
    esac
    shift 
done

if [[ "$BASE_URL" = "" ]]
then
    echo Base URL not provided
    exit 3
fi

if [[ "$USER" = "" ]]
then
    echo User name not provided
    exit 3
fi

if [[ "$ACCESS_KEY" = "" ]]
then
    echo Access key not provided
    exit 3
fi

URL=$BASE_URL/api/health-metrics

if [[ "$ACCESS_KEY" != "" ]]
then
    URL="$URL?prefix=$PREFIX"
fi


curl -u$USER:$ACCESS_KEY "$URL"

