Large synchronized code areas can lead to several problems.
Keep the synchronized code as short as possible, e.g., by using concurrent or atomic data structures.

# What Does This Check Look For?

This check searches for code that contains `synchronized` sections that exceed the configured maximum length.

# Why is This a Problem?

Concurrent code requires synchronization to provide safe access to shared state between threads.
This guarantees that no thread will ever observe the objects in an inconsistent state.

However, when large code areas are synchronized, it can lead to several issues:
- **Reduced performance**: Extended wait times for cooperating threads.
- **Deadlocks**: Two or more cooperating threads waiting on each other for unlocking.
- **Non-deterministic behavior**: The behavior depends on the order of synchronization.
- **Reduced comprehension**: Larger synchronized code regions require more effort to check dependencies between threads.

# How Can I resolve This?

To address this issue, you can:
1. **Use Concurrent Data Structures:** Utilize concurrent data structures, such as `ConcurrentMap` or atomics from the `java.util.concurrent.*` packages, to safely manage shared state.
2. **Keep Critical Sections Small:** Aim to keep critical sections as small as necessary and only synchronize shared state.

# Where Can I Learn More?

## References

- [Code Review Checklist (Java Concurrency): Item Sc.1](https://github.com/code-review-checklists/java-concurrency#minimize-critical-sections)
- _Effective Java_, 3rd Edition: Item 79 - Avoid excessive synchronization
