This check detects constant conditions in control flow statements, e.g. if statements or while loops.

# Why is This a Problem?

Constant conditions in control flow statements result in constant behaviour, making the control flow statement superfluous.
This is either an indication of an error in the condition, or a sign that the control flow statement can be removed. 

# How Can I Resolve This?
Confirm that the condition does, what it should. If this is not the case then adjust the condition.

If it is the case then:

a) If the condition is equivalent to `true`, remove the control flow statement.

b) If the condition is equivalent to `false`, remove the entire code block associated with the control flow statement.

## Example (Before)

```$LANGUAGE
if (a || !a) {...}
while ((a + b) == (b + a)) {...}
```

## Example (After)

```$LANGUAGE
if (a || !b) {...}
while ((a + b) == (b - a)) {...}
```
