Implementing `hashCode()` without `equals()` or vice versa can lead to unexpected behavior.
Ensure that if a class implements one, it also implements the other.

# What Does This Check Look For?

This check reports a finding when a class implements either `equals()` or `hashCode()` but not both.

# Why is This a Problem?

When a class implements `hashCode()` but not `equals()`, or vice versa, it violates the contract defined by the `Object` class. This discrepancy could lead to issues with collections that rely on these methods, such as `HashSet` or `HashMap`, potentially causing unexpected behavior or incorrect data handling. It's important for the consistency and predictability of your code that these methods are correctly paired.

# How Can I Resolve This?

If your class overrides one of these methods, ensure to override the other with appropriate logic. This consistency guarantees that objects are compared and hashed based on the same criteria, maintaining the integrity of collections and other structures relying on these methods. Review the logic of both methods to ensure they align and effectively support your class's equality and hashing requirements.

Some Integrated Development Environments (IDEs), including IntelliJ IDEA and Eclipse, can automatically generate the hashCode() and equals() methods for you. This ensures consistency between the two methods and saves you the hassle of manually writing them.

# Examples

## Non-Compliant

```java
class SomeClass {
    private int id;
    
    @Override
    public boolean equals(Object obj) {
        // equals logic
    }
    // hashCode() is missing
}
```

## Compliant

```java
class SomeClass {
    private int id;
    
    @Override
    public boolean equals(Object obj) {
        // equals logic
    }
    
    @Override
    public int hashCode() {
        // hashCode logic
    }
}
```
