This check detects class (record, enum) declarations that introduce type names which are also used in declarations in other packages.

# Why is This a Problem?

Using identical names for types from different packages can lead to mistakes when these types are used.
One may easily confuse them if the fully qualified name is not used or immediately visible to the programmer upon usage.

# How Can I Resolve This?

This can be avoided by using unique type names.

## Example (Before)

```Java
package some.pack.a;

public class PowerfulClass { /* ... */ }

// -----------------------
package some.pack.b;

public class PowerfulClass { /* ... */ }
```

## Example (After)

```Java
package some.pack.a;

public class CleverNameForA { /* ... */ }

// -----------------------
package some.pack.b;

public class SomeOtherSpecificName { /* ... */ }
```
