The name of the first function defined in a file should be the same as the filename.

# Why is This a Problem?
Matlab assumes that the first function in a file is named as the file itself.
If that is not the case, Matlab will use the filename as the function name.
Thus, the function will not be available under its given name which can easily lead to bugs.

# How Can I Resolve This?
Rename either the function or the filename to be consistent.

## Example (Before)

utils.m
```matlab
function ave = average(x)
    ave = sum(x(:))/numel(x); 
end
```

## Example (After)

average.m
```matlab
function ave = average(x)
    ave = sum(x(:))/numel(x); 
end
```

# Where Can I Learn More?

## References
- https://de.mathworks.com/help/matlab/ref/function.html