This check detects suboptimal usages of boolean assertions (`XCTAssert`, `XCTAssertTrue` and `XCTAssertFalse`) with comparison expressions in Objective-C and Objective-C++.

# Why is This a Problem?
It is recommended to use the appropriate specialized assertion when comparing values instead of using a boolean assertion, which may not provide a clear and specified error message if the assertion fails.

# How Can I Resolve This?

You should use the most specialized assertion available instead of using a boolean assertion with comparison expressions.

The available specialized assertions are:

- `XCTAssertEqual(expression1, expression2)`
  - Asserts `expression1 == expression2`
- `XCTAssertNotEqual(expression1, expression2)`
  - Asserts `expression1 != expression2`
- `XCTAssertGreaterThan(expression1, expression2)`
  - Asserts `expression1 > expression2`
- `XCTAssertGreaterThanOrEqual(expression1, expression2)`
  - Asserts `expression1 >= expression2`
- `XCTAssertLessThan(expression1, expression2)`
  - Asserts `expression1 < expression2`
- `XCTAssertLessThanOrEqual(expression1, expression2)`
  - Asserts `expression1 <= expression2`

## Example (Before)

```Objective-C
XCTAssertTrue(X == Y)
```

## Example (After)

```Objective-C
XCTAssertEqual(X, Y)
```

# Where Can I Learn More?

## Guidelines

- [XCTest assertions](https://developer.apple.com/documentation/xctest#2870839)