`unlock()` is used, but not called within a `finally` block.
Consider calling `unlock()` in a `finally` block to ensure proper cleanup.

# Why is This a Problem?

Locking (`lock()`, `lockInterruptibly()`, `tryLock()`) and unlocking (`unlock()`) methods must be used strictly with the recommended `try`-`finally` idiom when the critical region may throw exceptions.
Otherwise, the unlocking method may never be called and the lock will never be released.

# How Can I Resolve This?

Prefer concurrent data structures and algorithms (e.g., from `java.util.concurrent`) if possible.
Alternatively, prefer monitor locks via `synchronized` that provide an automatic unlock operation.
If neither is possible, use the `try`-`finally` idiom.

# Examples

## Non-Compliant

``` java
Lock l = ...;
l.lock();
// Access the resource protected by this lock.
l.unlock(); // If access throws, this will never be reached.
```

## Compliant

``` java
Lock l = ...;
l.lock();
try {
    // Access the resource protected by this lock.
} finally {
    l.unlock();
}
```

# Where Can I Learn More?

- [SEI CERT Oracle Coding Standard for Java: LCK08-J - Ensure actively held locks are released on exceptional conditions](https://wiki.sei.cmu.edu/confluence/display/java/LCK08-J.+Ensure+actively+held+locks+are+released+on+exceptional+conditions)
- [Code Review Checklist (Java Concurrency): Item Lk.4](https://github.com/code-review-checklists/java-concurrency#lock-unlock)
