Using subjective terms such as 'user friendly', ‘easy to use’, 'efficient', 'fast', and 'cost effective' in item fields can be ambiguous and misleading due to their relative nature. 
Relying on such terms to define requirements or design parameters leaves room for a wide range of interpretations which can lead to unexpected results, miscommunication, and the failure to meet expectations.
Instead, always strive to describe item fields using clear, consistent, and quantifiable terms or measures that leave no doubt about their intended meaning and outcome.

# What Does This Check Look For?

This check searches for subjective language in the specified fields within an Item. 
The existence of subjective language may indicate a lack of clear requirements, expectations, or guidelines.

# Why is This a Problem?

The usage of subjective language poses a problem because it can lead to different expectations among team members, stakeholders, or anyone interacting with the item. 
This can cause misunderstandings or false expectations, leading to inappropriate design decisions, inefficiencies in work, delays in delivery, or issues during product usage.

# How Can I Resolve This?

When describing an item's fields, instead of using subjective terms, describe the specific characteristics or requirements in concrete measurable terms or parameters. 
If a term like "user-friendly" or "efficient" is used, replace it with specific details about what makes it so. 
For instance, “efficient” could be described more specifically as "completes a given task within xx milliseconds" or "leverages xx% less resources compared to the previous version".

# Examples
## Non-Compliant

```markdown
# Spec Item Title
Description:
Develop a 'User-friendly', 'Efficient', and 'Cost-effective' system for prompt user authentication using social media credentials. 

// non-compliant: Uses subjective language in Item fields.
```

## Compliant

```markdown
# Spec Item Title
Description:
Implement a system that authenticates users via social media within 3 seconds, utilises 20% less server resources compared to the previous version, and gives a 15% reduction in yearly maintenance costs.

// compliant: Uses objective and quantifiable language in Item fields.
```

# Where Can I Learn More?

- Guideline: IEEE 29148: System and Software Engineering — Life Cycle Processes — Requirements Engineering.