/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.DotCoverReportParser;
import com.teamscale.reportparser.parser.ECoverageFormat;
import com.teamscale.reportparser.parser.GolangCoverageReportParser;
import com.teamscale.reportparser.parser.IecCoverageReportParser;
import com.teamscale.reportparser.parser.LauterbachTrace32CoverageReportParser;
import com.teamscale.reportparser.parser.LlvmCoverageReportParser;
import com.teamscale.reportparser.parser.SimpleCoverageReportParser;
import com.teamscale.reportparser.parser.VsCoverageReportParser;
import com.teamscale.reportparser.parser.XcodeCoverageReportParser;
import com.teamscale.reportparser.parser.clover.CloverReportParser;
import com.teamscale.reportparser.parser.cobertura.CoberturaReportParser;
import com.teamscale.reportparser.parser.compact.TeamscaleCompactCoverageReportParser;
import com.teamscale.reportparser.parser.ctc.CtcReportParser;
import com.teamscale.reportparser.parser.gcov.GcovReportParser;
import com.teamscale.reportparser.parser.jacoco.JaCoCoReportParser;
import com.teamscale.reportparser.parser.jlink.JLinkCsvCoverageReportParser;
import com.teamscale.reportparser.parser.lcov.LcovReportParser;
import java.util.EnumMap;
import java.util.function.Supplier;

public class CoverageReportParserFactory {
    private static final EnumMap<ECoverageFormat, Supplier<CoverageReportParserBase>> FACTORIES = new EnumMap(ECoverageFormat.class);

    public static CoverageReportParserBase createParser(ECoverageFormat format) {
        return (CoverageReportParserBase)FACTORIES.computeIfAbsent(format, f -> {
            throw new AssertionError((Object)("Missing factory for report format " + String.valueOf(f)));
        }).get();
    }

    static {
        FACTORIES.put(ECoverageFormat.CLOVER, CloverReportParser::new);
        FACTORIES.put(ECoverageFormat.COBERTURA, CoberturaReportParser::new);
        FACTORIES.put(ECoverageFormat.TEAMSCALE_COMPACT_COVERAGE, TeamscaleCompactCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.CTC, CtcReportParser::new);
        FACTORIES.put(ECoverageFormat.DOT_COVER, DotCoverReportParser::new);
        FACTORIES.put(ECoverageFormat.GCOV, GcovReportParser::new);
        FACTORIES.put(ECoverageFormat.GOLANG_COVERAGE, GolangCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.IEC_COVERAGE, IecCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.JACOCO, JaCoCoReportParser::new);
        FACTORIES.put(ECoverageFormat.LAUTERBACH_TRACE32, LauterbachTrace32CoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.LCOV, LcovReportParser::new);
        FACTORIES.put(ECoverageFormat.LLVM, LlvmCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.SIMPLE, SimpleCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.VS_COVERAGE, VsCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.XCODE, XcodeCoverageReportParser::new);
        FACTORIES.put(ECoverageFormat.JLINK_CSV, JLinkCsvCoverageReportParser::new);
    }
}

