/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.ISubQueryComputer;
import org.conqat.lib.commons.string.StringUtils;

public class HasParentQuery
implements IQuery {
    private final IQuery subQuery;

    public HasParentQuery(IQuery query) {
        this.subQuery = query;
    }

    public String toString() {
        return "hasParent(" + String.valueOf(this.subQuery) + ")";
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        Predicate<T> subPredicate = this.subQuery.compile(context);
        Function<T, String> parentIdAccessor = HasParentQuery.getParentIdAccessor(context);
        Function<T, String> idFieldAccessor = context.getIdAccessor();
        ParentSubQueryComputer<T> subQueryComputer = new ParentSubQueryComputer<T>(subPredicate, idFieldAccessor, parentIdAccessor);
        context.addSubQueryComputer(subQueryComputer);
        return subQueryComputer::evaluate;
    }

    private static <T> Function<T, String> getParentIdAccessor(ICompilationContext<T> context) throws QueryCompilationException {
        Function idAccessor = context.getIdAccessor();
        Function parentFieldAccessor = context.getAttributeAccessor("parent");
        BinaryOperator<String> parentFieldToIdTranslator = context.getIdResolver();
        return object -> (String)parentFieldToIdTranslator.apply((String)idAccessor.apply(object), (String)parentFieldAccessor.apply(object));
    }

    private static class ParentSubQueryComputer<T>
    implements ISubQueryComputer<T> {
        private final Predicate<T> subPredicate;
        private final Map<String, T> objectsById = new HashMap<String, T>();
        private final Function<T, String> idFieldAccessor;
        private final Function<T, String> parentIdFieldAccessor;

        public ParentSubQueryComputer(Predicate<T> subPredicate, Function<T, String> idFieldAccessor, Function<T, String> parentIdFieldAccessor) {
            this.subPredicate = subPredicate;
            this.idFieldAccessor = idFieldAccessor;
            this.parentIdFieldAccessor = parentIdFieldAccessor;
        }

        @Override
        public void updateState(T object, long timestamp) {
            this.objectsById.put(this.idFieldAccessor.apply(object), object);
        }

        public boolean evaluate(T object) {
            String parentId = this.parentIdFieldAccessor.apply(object);
            if (StringUtils.isEmpty((String)parentId)) {
                return false;
            }
            T parent = this.objectsById.get(parentId);
            if (parent == null) {
                return false;
            }
            return this.subPredicate.test(parent);
        }
    }
}

