/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.crypto;

import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemProviderBase;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.crypto.EncryptingStore;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class AutoEncryptingStorageSystemProvider
extends DelegatingStorageSystemProviderBase {
    public AutoEncryptingStorageSystemProvider(IStorageSystemProvider storageSystemProvider) {
        super(storageSystemProvider);
    }

    @Override
    protected IStore wrapStore(IStore store, String storeName, String storageSystemName) throws StorageException {
        if (EncryptedStorageHandler.isEncrypted(this.getSchemaEntry(storeName, storageSystemName))) {
            return new EncryptingStore(store);
        }
        return store;
    }

    private SchemaEntry getSchemaEntry(String storeName, String storageSystemName) throws StorageException, AssertionError {
        if ("_meta".equals(storeName)) {
            return new SchemaEntry(MetaIndex.class);
        }
        IndexSchema schema = IndexSchema.load(this.storageSystemProvider.openStorageSystem(storageSystemName), IndexSchemaCache.UNCACHED_ACCESS);
        CCSMAssert.isNotNull((Object)schema, (String)("Expecting schema to be present for storage system " + storageSystemName));
        SchemaEntry entry = schema.getEntry(storeName);
        CCSMAssert.isNotNull((Object)entry, (String)("Expecting entry to be present for store " + storeName));
        return entry;
    }
}

