/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HeadInsertingHistorizingStore;
import org.conqat.engine.persistence.store.hist.HeadReadOnlyHistorizingStore;
import org.conqat.engine.persistence.store.hist.TimestampReadOnlyHistorizingStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;

public class HistoryAccessOption {
    public static final long START_OF_HISTORY = 1L;
    private static final String NO_BRANCH_NAME = "##no-branch##";
    private final EHistoryAccessMode accessMode;
    private final long timestamp;
    private final String branchName;
    private long parentTimestamp = 0L;
    private String parentBranch = null;

    private HistoryAccessOption(EHistoryAccessMode accessMode, String branchName, long timestamp) {
        CCSMAssert.isTrue((timestamp > 0L ? 1 : 0) != 0, (String)"Timestamp must be positive.");
        CCSMAssert.isNotNull((Object)branchName);
        this.accessMode = accessMode;
        this.branchName = branchName;
        this.timestamp = timestamp;
    }

    public static HistoryAccessOption readHeadUnbranched() {
        return HistoryAccessOption.readHead(NO_BRANCH_NAME);
    }

    public static HistoryAccessOption readHead(String branchName) {
        return new HistoryAccessOption(EHistoryAccessMode.READ_HEAD, branchName, 1L);
    }

    public static HistoryAccessOption readTimestampUnbranched(long timestamp) {
        return HistoryAccessOption.readTimestamp(NO_BRANCH_NAME, timestamp);
    }

    public static HistoryAccessOption readTimestamp(String branchName, long timestamp) {
        return new HistoryAccessOption(EHistoryAccessMode.READ_TIMESTAMP, branchName, timestamp);
    }

    public static HistoryAccessOption readCommit(CommitDescriptor commit) {
        if (commit.isHeadCommit()) {
            return HistoryAccessOption.readHead(commit.getBranchName());
        }
        return HistoryAccessOption.readTimestamp(commit.getBranchName(), commit.getTimestamp());
    }

    public static HistoryAccessOption readHeadWriteTimestampUnbranched(long timestamp) {
        return HistoryAccessOption.readHeadWriteTimestamp(NO_BRANCH_NAME, timestamp);
    }

    public static HistoryAccessOption readHeadWriteTimestamp(String branchName, long timestamp) {
        return new HistoryAccessOption(EHistoryAccessMode.WRITE_TIMESTAMP, branchName, timestamp);
    }

    public HistoryAccessOption cloneToBranchedAccessOption(String branch) {
        CCSMAssert.isNotNull((Object)branch);
        HistoryAccessOption result = new HistoryAccessOption(this.accessMode, branch, this.timestamp);
        result.parentBranch = this.parentBranch;
        result.parentTimestamp = this.parentTimestamp;
        return result;
    }

    public HistoryAccessOption cloneToUnbranchedAccessOption() {
        return this.cloneToBranchedAccessOption(NO_BRANCH_NAME);
    }

    public HistoryAccessOption cloneWithNewTimestamp(String branchName, long timestamp) {
        CCSMAssert.isNotNull((Object)branchName);
        return new HistoryAccessOption(this.accessMode, branchName, timestamp);
    }

    public void setExplicitParentCommit(String branchName, long timestamp) {
        CCSMAssert.isTrue((this.parentBranch == null ? 1 : 0) != 0, (String)"May not set explicit parent twice!");
        CCSMAssert.isNotNull((Object)branchName);
        CCSMAssert.isTrue((timestamp > 0L ? 1 : 0) != 0, (String)"May only use positive parent timestamp!");
        this.parentBranch = branchName;
        this.parentTimestamp = timestamp;
    }

    public IStore createStore(IStore store, SchemaEntry schemaEntry) throws StorageException {
        if (schemaEntry.usesOption(EStorageOption.BRANCHED)) {
            return IBranchingLayer.create(store, schemaEntry).openStore(this);
        }
        if (schemaEntry.usesOption(EStorageOption.HISTORIZED)) {
            return this.createHistorizingStore(store);
        }
        throw new AssertionError((Object)("Unknown store flags for supporting historization: " + String.valueOf(schemaEntry)));
    }

    private IStore createHistorizingStore(IStore store) throws AssertionError {
        CCSMAssert.isTrue((boolean)NO_BRANCH_NAME.equals(this.branchName), (String)"Can use linear historizing store only for default branch!");
        return switch (this.accessMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new HeadReadOnlyHistorizingStore(store);
            case 1 -> new TimestampReadOnlyHistorizingStore(store, this.timestamp);
            case 2 -> new HeadInsertingHistorizingStore(store, this.timestamp);
        };
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampOrNow() {
        if (this.isReadHead()) {
            return DateTimeUtils.millisNow();
        }
        return this.timestamp;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public boolean isUnbranched() {
        return NO_BRANCH_NAME.equals(this.branchName);
    }

    public boolean isReadHead() {
        return this.accessMode == EHistoryAccessMode.READ_HEAD;
    }

    public String toString() {
        return String.valueOf((Object)this.accessMode) + "@" + this.branchName + ":" + this.timestamp;
    }

    public String toStringWithParent() {
        Object str = this.toString();
        if (this.parentBranch != null) {
            str = (String)str + "[parent=" + this.parentBranch + ":" + this.parentTimestamp + "]";
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HistoryAccessOption) {
            HistoryAccessOption other = (HistoryAccessOption)obj;
            return Objects.equals((Object)this.accessMode, (Object)other.accessMode) && this.timestamp == other.timestamp && Objects.equals(this.branchName, other.branchName) && this.parentTimestamp == other.parentTimestamp && Objects.equals(this.parentBranch, other.parentBranch);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessMode, this.timestamp, this.branchName, this.parentTimestamp, this.parentBranch});
    }

    public boolean isWriteMode() {
        return this.accessMode == EHistoryAccessMode.WRITE_TIMESTAMP;
    }

    public EHistoryAccessMode getAccessMode() {
        return this.accessMode;
    }

    public String getParentBranch() {
        return this.parentBranch;
    }

    public long getParentTimestamp() {
        return this.parentTimestamp;
    }

    public static enum EHistoryAccessMode {
        READ_HEAD,
        READ_TIMESTAMP,
        WRITE_TIMESTAMP;

    }
}

