/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.MigrationChanges;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.StringInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import com.teamscale.index.migration.finding.GlobalOptionReplacement;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass
class ProjectConfigurationComparisonContribution
extends ProjectComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> KNOWN_IGNORED_PROPERTIES = Set.of("externalStorageProjectMappingId");
    private static final String JSON_PROPERTY_SEPARATOR = ".";
    private static final String CONNECTOR_CONFIGURATIONS_PROPERTY = "connectorConfigurations";
    private static final String ANALYSIS_PROFILE_VERSION_PROPERTY = "analysisProfileVersion";
    private static final String ALLOW_ANY_VALUE_WILDCARD = "*";
    @JsonProperty(value="projectConfiguration")
    private final ObjectNode projectConfiguration;
    @JsonProperty(value="connectorConfigurations")
    private final Map<String, JsonNode> connectorConfigurations;
    @JsonProperty(value="analysisProfileVersion")
    private final @Nullable String analysisProfileVersion;
    private static final Map<String, Pair<String, String>> EXCLUDE_LIST_BY_CONTRIBUTION_ID = new HashMap<String, Pair<String, String>>();

    @JsonCreator
    ProjectConfigurationComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="project") String project, @JsonProperty(value="projectConfiguration") ObjectNode projectConfiguration, @JsonProperty(value="connectorConfigurations") Map<String, JsonNode> connectorConfigurations, @JsonProperty(value="analysisProfileVersion") @Nullable EAnalysisProfileVersion analysisProfileVersion) {
        super(contributor, project);
        this.projectConfiguration = projectConfiguration;
        this.connectorConfigurations = connectorConfigurations;
        this.analysisProfileVersion = analysisProfileVersion == null ? null : analysisProfileVersion.toString();
    }

    public ProjectConfigurationComparisonContribution(String contributor, String project, ProjectConfiguration projectConfiguration, @Nullable EAnalysisProfileVersion analysisProfileVersion) throws ConQATException {
        super(contributor, project);
        this.projectConfiguration = ProjectConfigurationComparisonContribution.serializeObject(projectConfiguration);
        this.pruneProjectConfiguration();
        this.connectorConfigurations = new HashMap<String, JsonNode>();
        ObjectMapper objectMapper = JsonUtils.getObjectMapper();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            this.connectorConfigurations.put(connector.getIdentifier(), objectMapper.valueToTree((Object)connector));
        }
        this.analysisProfileVersion = analysisProfileVersion == null ? null : analysisProfileVersion.toString();
    }

    private void pruneProjectConfiguration() {
        this.projectConfiguration.remove("internalId");
        this.projectConfiguration.remove("connectors");
        @Nullable ObjectNode embeddedProfile = (ObjectNode)this.projectConfiguration.get("embeddedProfile");
        if (embeddedProfile != null) {
            ProjectConfigurationComparisonContribution.pruneEmbeddedProfile(embeddedProfile);
            return;
        }
        ArrayNode codeScopes = (ArrayNode)this.projectConfiguration.get("codeScopes");
        CCSMAssert.isNotNull((Object)codeScopes, (String)"expected at least one code scope as there was no embedded profile attached to the project configuration, found none");
        for (JsonNode codeScope : codeScopes) {
            ObjectNode embeddedProfileForScope = (ObjectNode)codeScope.get("embeddedProfile");
            ProjectConfigurationComparisonContribution.pruneEmbeddedProfile(embeddedProfileForScope);
        }
    }

    private static void pruneEmbeddedProfile(ObjectNode embeddedProfile) {
        embeddedProfile.remove("qualityIndicators");
        ObjectNode qi = (ObjectNode)embeddedProfile.get("qualityIndicator");
        Iterator it = qi.elements();
        while (it.hasNext()) {
            ObjectNode qualityIndicatorNode = (ObjectNode)it.next();
            qualityIndicatorNode.remove("groups");
        }
    }

    public Map<String, StringInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        Map<String, String> result = ProjectConfigurationComparisonContribution.asFlatJson((JsonNode)this.projectConfiguration, "");
        this.handleChangesCausedByMigrations(result, context);
        for (Map.Entry<String, JsonNode> connectorConfiguration : this.connectorConfigurations.entrySet()) {
            String keyPrefix = "connectors." + connectorConfiguration.getKey();
            result.putAll(ProjectConfigurationComparisonContribution.asFlatJson(connectorConfiguration.getValue(), keyPrefix));
        }
        Predicate<Map.Entry> valueNotEmpty = entry -> !((String)entry.getValue()).isEmpty();
        return result.entrySet().stream().filter(valueNotEmpty).collect(Collectors.toMap(Map.Entry::getKey, entry -> new StringInstanceComparisonValue((String)entry.getKey(), (String)entry.getValue(), true)));
    }

    private void handleChangesCausedByMigrations(Map<String, String> result, InstanceComparisonContributionBase.ComparisonContext context) {
        MigrationChanges migrationChanges = this.collectRenamesFromMigrations(context.getGlobalStorageSystem());
        if (migrationChanges.isEmpty()) {
            return;
        }
        HashMap<String, String> propertiesToMove = new HashMap<String, String>();
        HashSet propertiesToDelete = new HashSet();
        result.forEach((property, value) -> {
            ProjectConfigurationComparisonContribution.handleGroupRenames(property, migrationChanges, propertiesToMove);
            ProjectConfigurationComparisonContribution.handleRenamedOptions(property, migrationChanges.getRenamedGlobalOptions(), propertiesToMove);
            ProjectConfigurationComparisonContribution.handleGroupsWithDeletedOptions(property, migrationChanges, propertiesToDelete);
            ProjectConfigurationComparisonContribution.handleDeletedOptions(property, migrationChanges.getDeletedOptions(), propertiesToDelete);
            ProjectConfigurationComparisonContribution.handleDeletedOptions(property, migrationChanges.getGlobalOptionDeletions(), propertiesToDelete);
        });
        propertiesToMove.forEach((oldPropertyName, newPropertyName) -> {
            result.put((String)newPropertyName, (String)result.get(oldPropertyName));
            result.remove(oldPropertyName);
        });
        propertiesToDelete.forEach(result::remove);
    }

    private static void handleRenamedOptions(String property, TwoDimHashMap<String, String, GlobalOptionReplacement> renamedGlobalOptions, Map<String, String> propertiesToMove) {
        renamedGlobalOptions.forEach((oldName, newName, optionReplacement) -> {
            if (property.endsWith(".options." + oldName)) {
                String newPropertyName = property.replace(".options." + oldName, ".options." + newName);
                propertiesToMove.put(property, newPropertyName);
            }
        });
    }

    private static void handleGroupsWithDeletedOptions(String property, MigrationChanges migrationChanges, Set<String> propertiesToDelete) {
        migrationChanges.getGroupsWithDeletedOptions().forEach(groupAndCheckName -> {
            if (property.endsWith(".analysisGroup." + (String)groupAndCheckName.getFirst() + ".options." + (String)groupAndCheckName.getSecond())) {
                propertiesToDelete.add(property);
            }
        });
    }

    private static void handleDeletedOptions(String property, Set<String> deletedOptions, Set<String> propertiesToDelete) {
        deletedOptions.forEach(deletedOption -> {
            if (property.endsWith(".options." + deletedOption)) {
                propertiesToDelete.add(property);
            }
        });
    }

    private static void handleGroupRenames(String property, MigrationChanges migrationChanges, Map<String, String> propertiesToMove) {
        migrationChanges.getRenamesByGroupAndOptionName().forEach((groupName, oldCheckName, optionReplacement) -> {
            if (property.endsWith(groupName + ".options." + oldCheckName)) {
                String newPropertyName = property.replace(JSON_PROPERTY_SEPARATOR + groupName + ".options." + oldCheckName, JSON_PROPERTY_SEPARATOR + optionReplacement.getNewGroupName() + ".options." + optionReplacement.getNewOptionName());
                propertiesToMove.put(property, newPropertyName);
            }
        });
    }

    protected MigrationChanges collectRenamesFromMigrations(GlobalStorageSystem globalStorageSystem) {
        return ProjectConfigurationComparisonContribution.collectMigrationChangesFor(this.projectConfiguration, this.analysisProfileVersion, globalStorageSystem);
    }

    @Override
    protected List<InstanceComparisonDiffEntryBase<?>> excludeIrrelevantEntries(List<InstanceComparisonDiffEntryBase<?>> diffs) {
        if (EXCLUDE_LIST_BY_CONTRIBUTION_ID.isEmpty()) {
            ProjectConfigurationComparisonContribution.readExcludeListTsv();
        }
        return CollectionUtils.filter(diffs, ProjectConfigurationComparisonContribution::shouldBeIgnored);
    }

    private static boolean shouldBeIgnored(InstanceComparisonDiffEntryBase<?> diff) {
        String stableComparisonKey = ProjectConfigurationComparisonContribution.getStableComparisonKey(diff.getName());
        if (KNOWN_IGNORED_PROPERTIES.contains(stableComparisonKey)) {
            return false;
        }
        Pair<String, String> allowListEntry = EXCLUDE_LIST_BY_CONTRIBUTION_ID.get(stableComparisonKey);
        if (allowListEntry == null || !(diff instanceof PredefinedImprovedInstanceComparisonDiffEntry)) {
            return true;
        }
        PredefinedImprovedInstanceComparisonDiffEntry stringEntry = (PredefinedImprovedInstanceComparisonDiffEntry)diff;
        boolean shouldBeIgnored = !(!((String)allowListEntry.getFirst()).equals(ALLOW_ANY_VALUE_WILDCARD) && !((String)stringEntry.getLocalValue()).equals(allowListEntry.getFirst()) || !((String)allowListEntry.getSecond()).equals(ALLOW_ANY_VALUE_WILDCARD) && !((String)stringEntry.getRemoteValue()).equals(allowListEntry.getSecond()));
        return !shouldBeIgnored;
    }

    private static void readExcludeListTsv() {
        String analysisProfileTsv = "ANALYSIS_PROFILE_VERSION_186.tsv";
        if (!Resource.exists(ProjectConfigurationComparisonContribution.class, (String)analysisProfileTsv)) {
            return;
        }
        String content = Resource.of(ProjectConfigurationComparisonContribution.class, (String)analysisProfileTsv).getContent();
        for (String line : StringUtils.splitLines((String)content)) {
            if (line.trim().startsWith("//")) continue;
            String[] parts = line.split("\t");
            if (parts.length != 3) {
                LOGGER.error("Internal error: Skipping invalid line in exclude-list file {} :\n{}", (Object)analysisProfileTsv, (Object)line);
                continue;
            }
            String id = parts[0];
            String valueBefore = parts[1];
            String valueAfter = parts[2];
            EXCLUDE_LIST_BY_CONTRIBUTION_ID.put(id, (Pair<String, String>)Pair.createPair((Object)valueBefore, (Object)valueAfter));
        }
    }

    @Override
    protected boolean isExcludedComparisonKey(String comparisonKey) {
        return KNOWN_IGNORED_PROPERTIES.contains(comparisonKey);
    }

    @VisibleForTesting
    static Map<String, String> asFlatJson(JsonNode root, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        ProjectConfigurationComparisonContribution.handleNode(root, prefix, result);
        return result;
    }

    private static void handleNode(JsonNode node, String key, Map<String, String> result) {
        if (node.isValueNode()) {
            ProjectConfigurationComparisonContribution.handleValueNode((ValueNode)node, key, result);
        } else if (node.isObject()) {
            ProjectConfigurationComparisonContribution.handleObjectNode((ObjectNode)node, key, result);
        } else if (node.isArray()) {
            ProjectConfigurationComparisonContribution.handleArrayNode((ArrayNode)node, key, result);
        }
    }

    private static void handleValueNode(ValueNode node, String key, Map<String, String> result) {
        if (ProjectConfigurationComparisonContribution.isQualityIndicatorEnablementValue(key, node)) {
            result.put(key, node.asText().toUpperCase());
            return;
        }
        result.put(key, node.asText());
    }

    private static boolean isQualityIndicatorEnablementValue(String key, ValueNode node) {
        try {
            EFindingEnablement.valueOf((String)node.asText().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        String qualityIndicatorProperty = "qualityIndicator";
        return key.contains(JSON_PROPERTY_SEPARATOR + qualityIndicatorProperty + JSON_PROPERTY_SEPARATOR);
    }

    private static void handleObjectNode(ObjectNode node, String key, Map<String, String> result) {
        Object prefix = key;
        if (!((String)prefix).isEmpty()) {
            prefix = key + JSON_PROPERTY_SEPARATOR;
        }
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            JsonNode childNode = node.get(fieldName);
            ProjectConfigurationComparisonContribution.handleNode(childNode, (String)prefix + fieldName, result);
        }
    }

    private static void handleArrayNode(ArrayNode node, String key, Map<String, String> result) {
        int elementIndex = 0;
        Iterator iter = node.elements();
        while (iter.hasNext()) {
            JsonNode next = (JsonNode)iter.next();
            ProjectConfigurationComparisonContribution.handleNode(next, key + "[" + elementIndex + "]", result);
            ++elementIndex;
        }
    }

    @Override
    protected List<InstanceComparisonDiffEntryBase<?>> computeOnlyInOneInstance(InstanceComparisonContributionBase toKeep, InstanceComparisonContributionBase toSubtract, boolean keepLocal, InstanceComparisonContributionBase.ComparisonContext context) {
        ObjectNode projectConfigurationToKeep = ((ProjectConfigurationComparisonContribution)toKeep).projectConfiguration;
        ObjectNode projectConfigurationToSubtract = ((ProjectConfigurationComparisonContribution)toSubtract).projectConfiguration;
        if (projectConfigurationToKeep.has("embeddedProfile") && projectConfigurationToSubtract.has("codeScopes")) {
            ProjectConfigurationComparisonContribution.moveProfilesFromDefaultCodeScopeToProjectConfiguration(projectConfigurationToSubtract);
        } else if (projectConfigurationToSubtract.has("embeddedProfile") && projectConfigurationToKeep.has("codeScopes")) {
            ProjectConfigurationComparisonContribution.moveProfilesFromDefaultCodeScopeToProjectConfiguration(projectConfigurationToKeep);
        }
        return super.computeOnlyInOneInstance(toKeep, toSubtract, keepLocal, context);
    }

    private static void moveProfilesFromDefaultCodeScopeToProjectConfiguration(ObjectNode projectConfiguration) {
        ArrayNode codeScopes = (ArrayNode)projectConfiguration.get("codeScopes");
        ObjectNode defaultCodeScope = (ObjectNode)codeScopes.get(codeScopes.size() - 1);
        if (defaultCodeScope == null || !defaultCodeScope.get("name").textValue().equals(CodeScopeAware.DEFAULT_CODE_SCOPE.name())) {
            CCSMAssert.isNotNull((Object)projectConfiguration.get("embeddedProfile"), (String)"expected embedded profile to exist as child of the project configuration");
            CCSMAssert.isNotNull((Object)projectConfiguration.get("profile"), (String)"expected profile name to exist as child of the project configuration");
            return;
        }
        CCSMAssert.isTrue((boolean)defaultCodeScope.get("name").textValue().equals(CodeScopeAware.DEFAULT_CODE_SCOPE.name()), (String)"expected a default code scope as last element in the list of code scopes");
        ObjectNode embeddedProfile = (ObjectNode)defaultCodeScope.get("embeddedProfile");
        TextNode profile = (TextNode)defaultCodeScope.get("profile");
        codeScopes.remove(codeScopes.size() - 1);
        projectConfiguration.set("embeddedProfile", (JsonNode)embeddedProfile);
        projectConfiguration.set("profile", (JsonNode)profile);
    }

    public @Nullable ObjectNode getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public @Nullable String getAnalysisProfileVersion() {
        return this.analysisProfileVersion;
    }
}

