/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.external;

import com.teamscale.index.repository.ERepositoryChangeType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

class ArchitectureChangeSquasher {
    private static final TwoDimHashMap<ERepositoryChangeType, ERepositoryChangeType, ERepositoryChangeType> CHANGE_TYPE_TRANSITION = new TwoDimHashMap();
    private static final ERepositoryChangeType NIL = null;
    private final Map<UniformPath, UniformPathChange> lastOperationForPath = new HashMap<UniformPath, UniformPathChange>();

    ArchitectureChangeSquasher() {
    }

    void reportAddOrEdit(UniformPath uniformPath, String newContent, boolean isEdit) {
        CCSMAssert.isNotNull((Object)newContent);
        ERepositoryChangeType lastRepositoryChangeType = this.getLastRepositoryChangeType(uniformPath);
        ERepositoryChangeType changeType = ArchitectureChangeSquasher.getChangeType(isEdit);
        ERepositoryChangeType squashedChangeType = (ERepositoryChangeType)((Object)CHANGE_TYPE_TRANSITION.getValue((Object)lastRepositoryChangeType, (Object)changeType));
        CCSMAssert.isNotNull((Object)((Object)squashedChangeType), () -> "Failed to compute the squashed change type for %s. Change type: %s. Last change type: %s.".formatted(new Object[]{uniformPath, changeType, lastRepositoryChangeType}));
        this.lastOperationForPath.put(uniformPath, new UniformPathChange(newContent, squashedChangeType));
    }

    void reportDelete(UniformPath uniformPath) {
        ERepositoryChangeType squashedChangeType = (ERepositoryChangeType)((Object)CHANGE_TYPE_TRANSITION.getValue((Object)this.getLastRepositoryChangeType(uniformPath), (Object)ERepositoryChangeType.DELETE));
        if (squashedChangeType == NIL) {
            this.lastOperationForPath.remove(uniformPath);
        } else {
            this.lastOperationForPath.put(uniformPath, new UniformPathChange(null, squashedChangeType));
        }
    }

    private static ERepositoryChangeType getChangeType(boolean isEdit) {
        if (isEdit) {
            return ERepositoryChangeType.EDIT;
        }
        return ERepositoryChangeType.ADD;
    }

    private ERepositoryChangeType getLastRepositoryChangeType(UniformPath uniformPath) {
        return Optional.ofNullable(this.lastOperationForPath.get(uniformPath)).map(UniformPathChange::getRepositoryChangeType).orElse(NIL);
    }

    Map<UniformPath, UniformPathChange> getOperationsByPath() {
        return CollectionUtils.asUnmodifiable(this.lastOperationForPath);
    }

    static {
        Arrays.stream(ERepositoryChangeType.values()).forEach(changeType -> CHANGE_TYPE_TRANSITION.putValue((Object)NIL, (Object)changeType, (Object)changeType));
        CHANGE_TYPE_TRANSITION.putValue((Object)ERepositoryChangeType.ADD, (Object)ERepositoryChangeType.EDIT, (Object)ERepositoryChangeType.ADD);
        CHANGE_TYPE_TRANSITION.putValue((Object)ERepositoryChangeType.EDIT, (Object)ERepositoryChangeType.EDIT, (Object)ERepositoryChangeType.EDIT);
        CHANGE_TYPE_TRANSITION.putValue((Object)ERepositoryChangeType.ADD, (Object)ERepositoryChangeType.DELETE, (Object)NIL);
        CHANGE_TYPE_TRANSITION.putValue((Object)ERepositoryChangeType.EDIT, (Object)ERepositoryChangeType.DELETE, (Object)ERepositoryChangeType.DELETE);
        CHANGE_TYPE_TRANSITION.putValue((Object)ERepositoryChangeType.DELETE, (Object)ERepositoryChangeType.ADD, (Object)ERepositoryChangeType.ADD);
    }

    static class UniformPathChange {
        private final String content;
        private final ERepositoryChangeType repositoryChangeType;

        private UniformPathChange(String content, ERepositoryChangeType repositoryChangeType) {
            this.content = content;
            this.repositoryChangeType = repositoryChangeType;
        }

        Optional<String> getContent() {
            return Optional.ofNullable(this.content);
        }

        ERepositoryChangeType getRepositoryChangeType() {
            return this.repositoryChangeType;
        }
    }
}

