/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.backup.BackupStatusBase;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.read.BackupImportOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class BackupImportStatus
extends BackupStatusBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="projectProgress")
    private final List<ImportProgress> projectProgress = new ArrayList<ImportProgress>();
    @JsonProperty(value="backupImportOptions")
    private final BackupImportOptions backupImportOptions;
    @JsonProperty(value="importedProjects")
    private final Set<PublicProjectId> importedProjects = new HashSet<PublicProjectId>();
    @JsonProperty(value="updatedProjects")
    private final Set<InternalProjectId> updatedProjects = new HashSet<InternalProjectId>();

    @JsonCreator
    public BackupImportStatus(@JsonProperty(value="backupImportOptions") BackupImportOptions backupImportOptions) {
        super("Waiting for backup import to start...");
        this.backupImportOptions = backupImportOptions;
    }

    public BackupImportOptions getBackupImportOptions() {
        return this.backupImportOptions;
    }

    public List<ImportProgress> getProjectProgress() {
        return this.projectProgress;
    }

    public void addUpdatedProject(InternalProjectId projectId) {
        this.updatedProjects.add(projectId);
    }

    public boolean isUpdatedProject(InternalProjectId projectId) {
        return this.updatedProjects.contains(projectId);
    }

    public UnmodifiableSet<InternalProjectId> getUpdateProjects() {
        return CollectionUtils.asUnmodifiable(this.updatedProjects);
    }

    public ImportProgress getOrCreateProjectStatus(PublicProjectId projectId) {
        return this.projectProgress.stream().filter(progress -> projectId.equals((Object)progress.project)).findFirst().orElseGet(() -> {
            ImportProgress progress = new ImportProgress(projectId);
            this.projectProgress.add(progress);
            return progress;
        });
    }

    public void finish() {
        if (this.getStatus() != EBackupStatus.FAILURE) {
            this.setStatus(this.projectProgress.stream().map(ImportProgress::getStatus).max(Comparator.naturalOrder()).orElse(EBackupStatus.SUCCESS));
        }
        this.setStatusMessage("Backup import finished");
    }

    public void addImportedProject(PublicProjectId projectId) {
        this.importedProjects.add(projectId);
    }

    public Set<PublicProjectId> getImportedProjects() {
        return CollectionUtils.asUnmodifiable(this.importedProjects);
    }

    @Override
    public Optional<PublicProjectId> getSingleProjectId() {
        return Optional.empty();
    }

    @IndexValueClass
    public static class ImportProgress
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="project")
        private final PublicProjectId project;
        @JsonProperty(value="status")
        private EBackupStatus status = EBackupStatus.IN_PROGRESS;
        @JsonProperty(value="statusMessage")
        private String statusMessage = "Importing...";
        @JsonProperty(value="logs")
        private final List<LoggingEventTransport> logs = new ArrayList<LoggingEventTransport>();
        @JsonIgnore
        private boolean loggedUnconfiguredCheck = false;

        @JsonCreator
        public ImportProgress(@JsonProperty(value="project") PublicProjectId project) {
            this.project = project;
        }

        public PublicProjectId getProject() {
            return this.project;
        }

        public synchronized EBackupStatus getStatus() {
            return this.status;
        }

        public synchronized void setStatus(EBackupStatus status) {
            this.status = status;
        }

        public synchronized String getStatusMessage() {
            return this.statusMessage;
        }

        public synchronized void setStatusMessage(String statusMessage) {
            this.info(statusMessage);
            this.statusMessage = statusMessage;
        }

        public synchronized List<LoggingEventTransport> getLogs() {
            return new ArrayList<LoggingEventTransport>(this.logs);
        }

        public synchronized void setFailed(String message) {
            this.error(message);
            this.status = EBackupStatus.FAILURE;
            this.statusMessage = "Import failed! " + message;
        }

        public synchronized void error(String message) {
            this.logs.add(LoggingEventTransport.of((String)message, (ELogLevel)ELogLevel.ERROR));
        }

        public synchronized void warn(String message) {
            this.logs.add(LoggingEventTransport.of((String)message, (ELogLevel)ELogLevel.WARN));
        }

        public synchronized void info(String message) {
            this.logs.add(LoggingEventTransport.of((String)message, (ELogLevel)ELogLevel.INFO));
        }

        public synchronized void logUnconfiguredCheck(String analysisProfile, String checkReadableName, String analysisGroupName) {
            if (!this.loggedUnconfiguredCheck) {
                this.loggedUnconfiguredCheck = true;
                this.warn("The backup contains analysis profiles that were last edited with an older version of Teamscale. There are new checks available in this version that could be enabled in the imported analysis profiles. Following is a list of new checks that could be enabled (via Projects -> Analysis Profiles).");
            }
            this.warn("New check available for analysis profile '" + analysisProfile + "': '" + checkReadableName + "' in analysis group '" + analysisGroupName + "'");
        }
    }
}

