/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LastChangeTrackingValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

@Index(name="finding-blacklist", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={FindingBlacklistInfo.class})
public class FindingBlacklistIndex
implements IProjectIndex,
IChangeTrackingIndex,
IDeltaTranslatingIndex<IndexDelta<String>> {
    private final LastChangeTrackingValueIndex<FindingBlacklistInfo> delegate;

    public FindingBlacklistIndex(IStore store) {
        this.delegate = new LastChangeTrackingValueIndex(store);
    }

    public List<String> getAllFindingIds() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public FindingBlacklistInfo getBlacklistInfo(String findingId) throws StorageException {
        return (FindingBlacklistInfo)this.delegate.getValue(findingId);
    }

    public List<FindingBlacklistInfo> getBlacklistInfos(List<String> findingIds) throws StorageException {
        return this.delegate.getValues(findingIds);
    }

    public void setBlacklistInfos(PairList<String, FindingBlacklistInfo> blackListInfos) throws StorageException {
        this.delegate.setValues(blackListInfos);
    }

    public Map<String, FindingBlacklistInfo> getAllBlacklistInfos() throws StorageException {
        return this.delegate.getAllEntries().toMap();
    }

    public void removeFromBlacklist(String findingId) throws StorageException {
        this.delegate.removeValue(findingId);
    }

    public void setOrMergeBlacklistEntries(PairList<String, FindingBlacklistInfo> blackListInfos, BinaryOperator<FindingBlacklistInfo> mergeFunction) throws StorageException {
        this.delegate.setOrMergeValues(blackListInfos, mergeFunction);
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public @NonNull IndexDelta<String> resolveDelta(KeyDelta delta) {
        return new IndexDelta(this.resolveToPublicKeys((Collection<StorageKey>)delta.getAddedOrChangedKeys()), this.resolveToPublicKeys((Collection<StorageKey>)delta.getDeletedKeys()), Comparator.naturalOrder());
    }

    private Set<String> resolveToPublicKeys(Collection<StorageKey> keys) throws IllegalArgumentException {
        return this.delegate.resolveToPublicKeys(keys).stream().map(StorageKey::getAsString).collect(Collectors.toSet());
    }
}

