/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import com.teamscale.index.configuration.ProjectValidationUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AnalysisProfileUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String AUDIT_ANALYSIS_PROFILE_DIRECTORY_NAME = "analysis-profiles/audit";
    private static final String DEFAULT_ANALYSIS_PROFILE_DIRECTORY_NAME = "analysis-profiles/default";
    private static final String DEFAULT_PROFILE_VIEW_GROUP_NAME = "Default Profile Viewers";
    private static final String DEFAULT_ANALYSIS_PROFILE_SUFFIX = " (default)";

    public static void createGlobalOptions(AnalysisProfile profile, ConfigurationTemplate template) {
        List globalOptions = template.getGlobalOptions();
        for (ConfigOptionDescriptorBase globalOption : globalOptions) {
            profile.setOptionValue(globalOption.getName(), AnalysisProfileUtils.getItemValue((ConfigurationItemBase)globalOption, template.getCodeScope()));
        }
    }

    public static void createQualityIndicators(AnalysisProfile profile, ConfigurationTemplate template) {
        for (QualityIndicatorTemplate qualityIndicatorTemplate : template.getQualityIndicators()) {
            Optional<QualityIndicator> existingQualityIndicator = profile.getQualityIndicators().stream().filter(indicator -> indicator.getName().equals(qualityIndicatorTemplate.getName())).findFirst();
            QualityIndicator qualityIndicator = existingQualityIndicator.orElse(new QualityIndicator(qualityIndicatorTemplate.getName()));
            for (String groupName : qualityIndicatorTemplate.getGroupNames()) {
                AnalysisGroupDescriptor groupDescriptor = template.getAnalysisGroup(groupName);
                Optional<AnalysisGroup> existingGroup = qualityIndicator.getGroups().stream().filter(grp -> grp.getName().equals(groupDescriptor.getName())).findFirst();
                AnalysisGroup group = existingGroup.orElse(new AnalysisGroup(groupDescriptor.getName()));
                for (ConfigurationItemBase item : groupDescriptor.getConfigurationItems()) {
                    group.setOptionValue(item.getName(), AnalysisProfileUtils.getItemValue(item, template.getCodeScope()));
                }
                if (group.getOptionNames().isEmpty() || !existingGroup.isEmpty()) continue;
                qualityIndicator.addGroup(group);
            }
            for (ConfigOptionDescriptorBase option : qualityIndicatorTemplate.getVisibleOptions()) {
                qualityIndicator.setOptionValue(option.getName(), AnalysisProfileUtils.getItemValue((ConfigurationItemBase)option, template.getCodeScope()));
            }
            if (qualityIndicator.getGroups().isEmpty() || !existingQualityIndicator.isEmpty()) continue;
            profile.addQualityIndicator(qualityIndicator);
        }
    }

    public static String getItemValue(ConfigurationItemBase item, @Nullable CodeScopeName codeScopeName) {
        if (codeScopeName == null) {
            codeScopeName = CodeScopeAware.DEFAULT_CODE_SCOPE;
        }
        if (item instanceof FindingDescriptor) {
            return ((FindingDescriptor)item).getEnablement().name();
        }
        if (item instanceof MetricDescriptor) {
            return String.valueOf(((MetricDescriptor)item).isMetricEnabled());
        }
        if (item instanceof ConfigOptionDescriptorBase) {
            return ((ConfigOptionDescriptorBase)item).retrieveValueAsString(codeScopeName);
        }
        return null;
    }

    public static void insertDefaultAnalysisProfiles(GlobalStorageSystem schemaAwareGlobalPartition, Logger logger) throws StorageException {
        AnalysisProfileVersionedIndex profileVersionIndex = (AnalysisProfileVersionedIndex)schemaAwareGlobalPartition.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)schemaAwareGlobalPartition.openGlobalIndex(AnalysisProfileIndex.class);
        PermissionIndex permissionIndex = (PermissionIndex)schemaAwareGlobalPartition.openGlobalIndex(PermissionIndex.class);
        UserGroup viewGroup = UserGroupUtils.getOrCreateUserGroup((GlobalStorageSystem)schemaAwareGlobalPartition, (String)DEFAULT_PROFILE_VIEW_GROUP_NAME);
        for (ELanguage language : AnalysisProfileUtils.getSupportedLanguages()) {
            String profileName = AnalysisProfileUtils.getDefaultAnalysisProfileName(language);
            AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(profileName);
            if (analysisProfile != null && profileVersionIndex.getAnalysisProfileVersionHistory(profileName) != null) continue;
            if (analysisProfile != null && profileVersionIndex.getAnalysisProfileVersionHistory(profileName) == null) {
                AnalysisProfileUtils.addNewAnalysisProfileVersion(profileVersionIndex, analysisProfileIndex, analysisProfile, "", "Default Profile", schemaAwareGlobalPartition);
                continue;
            }
            HashSet activeLanguage = CollectionUtils.asHashSet((Object[])new ELanguage[]{language});
            Set<EAnalysisTool> tools = AnalysisProfileUtils.collectInternalTools(language);
            AnalysisProfile profile = new AnalysisProfile(profileName, (Set)activeLanguage, tools);
            AnalysisProfileUtils.createQualityIndicatorsAndGlobalOptions(schemaAwareGlobalPartition, logger, language, activeLanguage, tools, profile);
            AnalysisProfileUtils.addNewAnalysisProfileVersion(profileVersionIndex, analysisProfileIndex, profile, "", "Default Profile", schemaAwareGlobalPartition);
            permissionIndex.changeBasicRoleAssignments(EBasicPermissionScope.ANALYSIS_PROFILES, profileName, new RoleChange((ISubject)viewGroup, EBasicRole.VIEWER.getReadableName()));
        }
    }

    public static @NonNull String getDefaultAnalysisProfileName(@NonNull ELanguage language) {
        return language.getReadableName() + DEFAULT_ANALYSIS_PROFILE_SUFFIX;
    }

    public static void createQualityIndicatorsAndGlobalOptions(GlobalStorageSystem schemaAwareGlobalPartition, Logger logger, ELanguage language, Set<ELanguage> activeLanguage, Set<EAnalysisTool> tools, AnalysisProfile profile) {
        try {
            ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate(activeLanguage, tools, schemaAwareGlobalPartition);
            AnalysisProfileUtils.createQualityIndicators(profile, template);
            AnalysisProfileUtils.createGlobalOptions(profile, template);
        }
        catch (ProjectConfigurationException e) {
            logger.fatal("Error creating analysis profile for " + language.getReadableName(), (Throwable)e);
        }
    }

    private static void importAdditionalAnalysisProfiles(GlobalStorageSystem schemaAwareGlobalPartition, List<Resource> profiles, String user, String analysisProfileHistoryComment) throws StorageException, MigrationException {
        if (profiles.isEmpty()) {
            LOGGER.error("No analysis profile for import were found.");
            return;
        }
        profiles.removeIf(resource -> resource.hasExtension(new String[]{"md"}));
        AnalysisProfileVersionedIndex profileVersionIndex = (AnalysisProfileVersionedIndex)schemaAwareGlobalPartition.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex profileIndex = (AnalysisProfileIndex)schemaAwareGlobalPartition.openGlobalIndex(AnalysisProfileIndex.class);
        for (Resource analysisProfile : profiles) {
            try {
                AnalysisProfile profile = AnalysisProfileUtils.deserializeAnalysisProfile(analysisProfile.getContent(), schemaAwareGlobalPartition);
                if (profileIndex.getProfile(profile.getName()) != null) continue;
                AnalysisProfileUtils.addNewAnalysisProfileVersion(profileVersionIndex, profileIndex, profile, user, analysisProfileHistoryComment, schemaAwareGlobalPartition);
            }
            catch (InternalServerErrorException e) {
                LOGGER.error("Failed to load analysis profile from " + analysisProfile.getName(), (Throwable)e);
            }
        }
    }

    static Set<EAnalysisTool> collectInternalTools(ELanguage language) {
        HashSet<EAnalysisTool> tools = new HashSet<EAnalysisTool>();
        for (EAnalysisTool tool : EAnalysisTool.getAllToolsFor((ELanguage)language)) {
            if (!tool.isEnabledByDefault()) continue;
            tools.add(tool);
        }
        return tools;
    }

    public static boolean isMetricEnabledInProfile(AnalysisProfile profile, String analysisGroup, String metricName) {
        String option = AnalysisProfileUtils.getOptionValue(profile, analysisGroup, metricName);
        if (option == null) {
            return false;
        }
        return option.trim().equals(Boolean.TRUE.toString());
    }

    public static String getOptionValue(AnalysisProfile profile, String analysisGroupName, String optionName) {
        AnalysisGroup group = AnalysisProfileUtils.getAnalysisGroup(profile, analysisGroupName);
        if (group != null) {
            return group.getOptionValue(optionName);
        }
        return null;
    }

    public static boolean isAnalysisGroupEnabled(AnalysisProfile profile, String groupName) {
        return AnalysisProfileUtils.getAnalysisGroup(profile, groupName) != null;
    }

    public static @Nullable AnalysisGroup getAnalysisGroup(AnalysisProfile profile, String groupName) {
        return profile.getQualityIndicators().stream().flatMap(indicator -> indicator.getGroups().stream()).filter(group -> group.getName().equals(groupName)).findAny().orElse(null);
    }

    private static void validateAndInsertAnalysisProfile(AnalysisProfileIndex analysisProfileIndex, GlobalStorageSystem globalStorageSystem, AnalysisProfile analysisProfile) throws StorageException {
        ProjectValidationUtils.validateAnalysisProfile(analysisProfile, globalStorageSystem, true);
        AnalysisProfileVersionedIndex profileVersionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileUtils.updateCurrentProfileSilently(profileVersionedIndex, analysisProfileIndex, analysisProfile);
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileUtils.addNewAnalysisProfileVersion(analysisProfileVersionedIndex, analysisProfileIndex, analysisProfile, "[System]", "Profile updated by System", globalStorageSystem);
    }

    public static AnalysisProfile deserializeAnalysisProfile(byte[] data, GlobalStorageSystem globalStorageSystem) throws MigrationException {
        return AnalysisProfileUtils.deserializeAnalysisProfile(StringUtils.bytesToString((byte[])data), globalStorageSystem);
    }

    public static AnalysisProfile deserializeAnalysisProfile(String profileContent, GlobalStorageSystem globalStorageSystem) throws MigrationException {
        return (AnalysisProfile)TeamscaleVersionContainer.fromJson((String)profileContent, (Object)EAnalysisProfileVersion.context(globalStorageSystem), AnalysisProfile.class, (Enum)EAnalysisProfileVersion.CURRENT_VERSION, (String)"analysis profile");
    }

    public static AnalysisProfile createAnalysisProfile(byte[] data, AnalysisProfileIndex analysisProfileIndex, GlobalStorageSystem globalStorageSystem) throws MigrationException, StorageException {
        AnalysisProfile analysisProfile = AnalysisProfileUtils.deserializeAnalysisProfile(data, globalStorageSystem);
        if (analysisProfile != null) {
            AnalysisProfileUtils.validateAndInsertAnalysisProfile(analysisProfileIndex, globalStorageSystem, analysisProfile);
        }
        return analysisProfile;
    }

    public static List<ELanguage> getSupportedLanguages() {
        ArrayList<ELanguage> languages = new ArrayList<ELanguage>(IndexBasedAnalysisConstants.getLanguagesToShow());
        Collections.sort(languages);
        return languages;
    }

    public static AnalysisProfile updateAnalysisProfile(AnalysisProfileIndex analysisProfileIndex, ProjectStorageSystem projectStorageSystem, String analysisProfileName) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return AnalysisProfileUtils.updateAnalysisProfile(analysisProfileIndex, projectMetaIndex, projectConfiguration, analysisProfileName);
    }

    public static @NonNull AnalysisProfile updateAnalysisProfile(AnalysisProfileIndex analysisProfileIndex, MetaIndex projectMetaIndex, ProjectConfiguration projectConfiguration, String analysisProfileName) throws StorageException {
        AnalysisProfile latestProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (latestProfile == null) {
            throw new InternalServerErrorException("No analysis profile with the name '" + analysisProfileName + "' exists. Can't update.");
        }
        List codeScopesForAnalysisProfile = projectConfiguration.getCodeScopeNamesForAnalysisProfile(analysisProfileName);
        CCSMAssert.isNotEmpty((Collection)codeScopesForAnalysisProfile, (String)"expected an update of the analysis profile for at least one code scope, but got none");
        for (CodeScopeName codeScopeName : codeScopesForAnalysisProfile) {
            projectConfiguration.setEmbeddedProfile(latestProfile, codeScopeName);
        }
        projectMetaIndex.setValue((MetaIndex.IMetaIndexEntry)projectConfiguration, ProjectConfiguration.class);
        return latestProfile;
    }

    public static Set<String> synchronizeAnalysisGroups(ConfigurationTemplate template, AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        ConfigurationTemplate previousTemplate = AnalysisProfileUtils.getTemplateForProfile(analysisProfile, globalStorageSystem);
        Map<String, AnalysisGroup> analysisGroups = AnalysisProfileUtils.getAnalysisGroups(analysisProfile);
        HashSet<String> unusedAnalysisGroups = new HashSet<String>();
        for (AnalysisGroupDescriptor analysisGroupDescriptor : template.getAnalysisGroups()) {
            AnalysisGroup analysisGroup = analysisGroups.get(analysisGroupDescriptor.getName());
            if (analysisGroup != null) {
                AnalysisProfileUtils.synchronizeAnalysisGroup(template, analysisProfile, analysisGroupDescriptor, analysisGroup);
                continue;
            }
            if (previousTemplate.getAnalysisGroup(analysisGroupDescriptor.getName()) == null) continue;
            unusedAnalysisGroups.add(analysisGroupDescriptor.getName());
        }
        return unusedAnalysisGroups;
    }

    public static ConfigurationTemplate getTemplateForProfile(AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        return ConfigRegistry.getInstance().createConfigurationTemplate((Set)analysisProfile.getLanguages(), (Set)analysisProfile.getTools(), globalStorageSystem);
    }

    public static ConfigurationTemplateManager getTemplateManager(AnalysisProfileIndex analysisProfileIndex, GlobalStorageSystem globalStorageSystem, ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException {
        List analysisProfiles = analysisProfileIndex.getProfiles(projectConfiguration.getAnalysisProfileNames().stream().toList(), false);
        AnalysisProfileUtils.getConfiguredLanguages(analysisProfiles);
        CodeScopeAware configuredLanguagesPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware configuredToolsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScope : projectConfiguration.getCodeScopeNames()) {
            AnalysisProfile analysisProfileForCodeScope = analysisProfiles.stream().filter(profile -> profile.getName().equals(projectConfiguration.getAnalysisProfileName(codeScope))).findFirst().orElseThrow();
            configuredLanguagesPerCodeScope.setValue(codeScope, (Object)analysisProfileForCodeScope.getLanguages());
            configuredToolsPerCodeScope.setValue(codeScope, (Object)analysisProfileForCodeScope.getTools());
        }
        return ConfigRegistry.getInstance().initializeConfigurationTemplateManager(configuredLanguagesPerCodeScope, configuredToolsPerCodeScope, (Collection)projectConfiguration.getCodeScopeNames(), globalStorageSystem);
    }

    public static Map<String, AnalysisGroup> getAnalysisGroups(AnalysisProfile analysisProfile) {
        HashMap<String, AnalysisGroup> result = new HashMap<String, AnalysisGroup>();
        for (QualityIndicator qualityIndicator : analysisProfile.getQualityIndicators()) {
            for (AnalysisGroup group : qualityIndicator.getGroups()) {
                result.put(group.getName(), group);
            }
        }
        return result;
    }

    private static void synchronizeAnalysisGroup(ConfigurationTemplate template, AnalysisProfile analysisProfile, AnalysisGroupDescriptor analysisGroupDescriptor, AnalysisGroup analysisGroup) throws ProjectConfigurationException {
        AnalysisProfileUtils.initDefaults(analysisGroupDescriptor, analysisGroup, analysisProfile);
        QualityIndicator qualityIndicator = Objects.requireNonNull(AnalysisProfileUtils.getQualityIndicator(analysisProfile, analysisGroup));
        QualityIndicatorTemplate qualityIndicatorTemplate = AnalysisProfileUtils.getQualityIndicatorTemplate(template, analysisGroupDescriptor);
        if (qualityIndicatorTemplate == null || !qualityIndicator.getName().equals(qualityIndicatorTemplate.getName())) {
            if (qualityIndicatorTemplate != null) {
                qualityIndicatorTemplate.removeGroups(Collections.singleton(analysisGroup.getName()));
            }
            template.getOrCreateQualityIndicatorTemplate(qualityIndicator.getName()).addGroup(analysisGroupDescriptor);
        }
    }

    private static QualityIndicatorTemplate getQualityIndicatorTemplate(ConfigurationTemplate template, AnalysisGroupDescriptor analysisGroupDescriptor) {
        for (QualityIndicatorTemplate qualityIndicator : template.getQualityIndicators()) {
            if (!qualityIndicator.getGroupNames().contains((Object)analysisGroupDescriptor.getName())) continue;
            return qualityIndicator;
        }
        return null;
    }

    private static QualityIndicator getQualityIndicator(AnalysisProfile profile, AnalysisGroup analysisGroup) {
        for (QualityIndicator qualityIndicator : profile.getQualityIndicators()) {
            if (!qualityIndicator.getGroups().contains((Object)analysisGroup)) continue;
            return qualityIndicator;
        }
        CCSMAssert.fail((String)("Did not find quality indicator for " + String.valueOf(analysisGroup)));
        return null;
    }

    private static void initDefaults(AnalysisGroupDescriptor analysisGroupDescriptor, AnalysisGroup analysisGroup, AnalysisProfile analysisProfile) throws ProjectConfigurationException {
        UnmodifiableList configItems = analysisGroupDescriptor.getConfigurationItems();
        for (ConfigurationItemBase configItem : configItems) {
            AnalysisProfileUtils.adoptValue((ConfigurableObjectBase)analysisGroup, configItem, analysisGroupDescriptor, analysisProfile);
        }
    }

    private static void adoptValue(ConfigurableObjectBase configurableObject, ConfigurationItemBase configurationItem, AnalysisGroupDescriptor analysisGroupDescriptor, AnalysisProfile analysisProfile) throws ProjectConfigurationException {
        String optionValue = configurableObject.getOptionValue(configurationItem.getName());
        if (optionValue != null) {
            configurationItem.setValue(optionValue, CodeScopeAware.DEFAULT_CODE_SCOPE);
            if (configurationItem instanceof ConfigOptionDescriptorBase) {
                ((ConfigOptionDescriptorBase)configurationItem).setValueAndDefaultValue(optionValue, CodeScopeAware.DEFAULT_CODE_SCOPE);
            }
        } else if (configurationItem instanceof FindingDescriptor) {
            FindingDescriptor findingDescriptor = (FindingDescriptor)configurationItem;
            if (analysisProfile.getTools().contains((Object)findingDescriptor.getTool()) && !CollectionUtils.intersectionSet((Collection)analysisProfile.getLanguages(), (Collection[])new Collection[]{findingDescriptor.getLanguages()}).isEmpty()) {
                findingDescriptor.setValue(EFindingEnablement.UNDECIDED.toString(), CodeScopeAware.DEFAULT_CODE_SCOPE);
                if (analysisGroupDescriptor != null) {
                    analysisGroupDescriptor.addUnconfiguredCheck(findingDescriptor.getName(), findingDescriptor.getReadableName());
                }
            }
        }
    }

    public static void initDefaultsFromProfile(ConfigurationTemplate template, AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        Set<String> unusedAnalysisGroups = AnalysisProfileUtils.synchronizeAnalysisGroups(template, analysisProfile, globalStorageSystem);
        AnalysisProfileUtils.synchronizeQualityIndicators(template, analysisProfile, unusedAnalysisGroups);
        AnalysisProfileUtils.initGlobalOptions(template, analysisProfile);
    }

    private static void synchronizeQualityIndicators(ConfigurationTemplate template, AnalysisProfile analysisProfile, Set<String> unusedAnalysisGroups) throws ProjectConfigurationException {
        AnalysisProfileUtils.addAdditionalQualityIndicators(template, analysisProfile);
        HashMap<String, QualityIndicator> qualityIndicatorsByName = new HashMap<String, QualityIndicator>();
        for (QualityIndicator qualityIndicator : analysisProfile.getQualityIndicators()) {
            qualityIndicatorsByName.put(qualityIndicator.getName(), qualityIndicator);
        }
        HashSet<String> emptyQualityIndicatorTemplates = new HashSet<String>();
        for (QualityIndicatorTemplate qualityIndicatorTemplate : template.getQualityIndicators()) {
            QualityIndicator qualityIndicator = (QualityIndicator)qualityIndicatorsByName.get(qualityIndicatorTemplate.getName());
            if (qualityIndicator != null) {
                AnalysisProfileUtils.adoptAdditionalAnalysisGroups(template, qualityIndicatorTemplate, qualityIndicator, analysisProfile);
                for (ConfigOptionDescriptorBase option : qualityIndicatorTemplate.getVisibleOptions()) {
                    AnalysisProfileUtils.adoptValue((ConfigurableObjectBase)qualityIndicator, (ConfigurationItemBase)option, null, analysisProfile);
                }
            }
            qualityIndicatorTemplate.removeGroups(unusedAnalysisGroups);
            if (!qualityIndicatorTemplate.getGroupNames().isEmpty()) continue;
            emptyQualityIndicatorTemplates.add(qualityIndicatorTemplate.getName());
        }
        template.removeQualityIndicatorTemplates(emptyQualityIndicatorTemplates);
    }

    private static void adoptAdditionalAnalysisGroups(ConfigurationTemplate targetTemplate, QualityIndicatorTemplate qualityIndicatorTemplate, QualityIndicator qualityIndicator, AnalysisProfile analysisProfile) throws ProjectConfigurationException {
        for (AnalysisGroup analysisGroup : qualityIndicator.getGroups()) {
            AnalysisGroupDescriptor analysisGroupFromTargetTemplate;
            if (qualityIndicatorTemplate.getGroupNames().contains((Object)analysisGroup.getName()) || (analysisGroupFromTargetTemplate = targetTemplate.getAnalysisGroup(analysisGroup.getName())) == null) continue;
            qualityIndicatorTemplate.addGroup(analysisGroupFromTargetTemplate);
            AnalysisProfileUtils.initDefaults(analysisGroupFromTargetTemplate, analysisGroup, analysisProfile);
        }
    }

    private static void addAdditionalQualityIndicators(ConfigurationTemplate template, AnalysisProfile analysisProfile) {
        for (QualityIndicator qualityIndicator : analysisProfile.getQualityIndicators()) {
            if (template.getQualityIndicator(qualityIndicator.getName()) != null) continue;
            UnmodifiableList analysisGroups = qualityIndicator.getGroups();
            QualityIndicatorTemplate qualityIndicatorTemplate = new QualityIndicatorTemplate(qualityIndicator.getName(), (Set)analysisProfile.getLanguages(), new AnalysisGroupDescriptor[0]);
            for (AnalysisGroup analysisGroup : analysisGroups) {
                AnalysisGroupDescriptor analysisGroupDescriptor = template.getAnalysisGroup(analysisGroup.getName());
                if (analysisGroupDescriptor == null) continue;
                qualityIndicatorTemplate.addGroup(analysisGroupDescriptor);
            }
            template.registerQualityIndicatorTemplate(qualityIndicatorTemplate);
        }
    }

    private static void initGlobalOptions(ConfigurationTemplate template, AnalysisProfile analysisProfile) throws ProjectConfigurationException {
        List globalOptions = template.getGlobalOptions();
        for (ConfigOptionDescriptorBase globalOption : globalOptions) {
            AnalysisProfileUtils.adoptValue((ConfigurableObjectBase)analysisProfile, (ConfigurationItemBase)globalOption, null, analysisProfile);
        }
    }

    public static List<FindingDescriptor> getFindingsDescriptors(AnalysisGroup group, ConfigurationTemplate template) {
        AnalysisGroupDescriptor groupDescriptor = template.getAnalysisGroup(group.getName());
        CCSMAssert.isNotNull((Object)groupDescriptor, (String)"expected group descriptor for analysis group %s to exist".formatted(group.getName()));
        return CollectionUtils.filterAndMap((Collection)groupDescriptor.getConfigurationItems(), FindingDescriptor.class::isInstance, FindingDescriptor.class::cast);
    }

    public static List<FindingDescriptor> getFindingsDescriptors(ConfigurationTemplate template) {
        UnmodifiableList groupDescriptor = template.getAnalysisGroups();
        List items = groupDescriptor.stream().map(AnalysisGroupDescriptor::getConfigurationItems).flatMap(Collection::stream).toList();
        return CollectionUtils.filterAndMap(items, FindingDescriptor.class::isInstance, FindingDescriptor.class::cast);
    }

    public static EAnalysisTool getAnalysisTool(AnalysisGroup group, ConfigurationTemplate template) {
        List<FindingDescriptor> findingsDescriptors = AnalysisProfileUtils.getFindingsDescriptors(group, template);
        if (CollectionUtils.isNullOrEmpty(findingsDescriptors)) {
            return EAnalysisTool.TEAMSCALE;
        }
        return findingsDescriptors.get(0).getTool();
    }

    public static Set<ELanguage> getConfiguredLanguages(MetaIndex projectMetaIndex) throws StorageException {
        ProjectConfiguration configuration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return configuration.getConfiguredLanguages();
    }

    public static Set<ELanguage> getConfiguredLanguages(Collection<AnalysisProfile> analysisProfiles) {
        return analysisProfiles.stream().flatMap(profile -> profile.getLanguages().stream()).collect(Collectors.toSet());
    }

    public static Set<EAnalysisTool> getConfiguredTools(MetaIndex projectMetaIndex) throws StorageException {
        ProjectConfiguration configuration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return configuration.getConfiguredTools();
    }

    public static Set<EAnalysisTool> getConfiguredTools(Collection<AnalysisProfile> analysisProfiles) {
        return analysisProfiles.stream().flatMap(profile -> profile.getTools().stream()).collect(Collectors.toSet());
    }

    @Deprecated
    public static @NonNull AnalysisProfile getDefaultEmbeddedAnalysisProfile(ProjectStorageSystem projectStorageSystem) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        AnalysisProfile analysisProfile = projectConfiguration.getEmbeddedDefaultProfile();
        return Objects.requireNonNull(analysisProfile);
    }

    public static @NonNull AnalysisProfile getEmbeddedAnalysisProfile(IndexLayer indexLayer, PublicProjectId projectId, CodeScopeName codeScopeName) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        return AnalysisProfileUtils.getEmbeddedAnalysisProfile(projectMetaIndex, codeScopeName);
    }

    public static @NonNull AnalysisProfile getEmbeddedAnalysisProfile(MetaIndex projectMetaIndex, CodeScopeName codeScopeName) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        AnalysisProfile analysisProfile = projectConfiguration.getEmbeddedProfile(codeScopeName);
        CCSMAssert.isNotNull((Object)analysisProfile, (String)"expected embedded analysis profile for code scope '%s' in project '%s', but was null".formatted(codeScopeName, projectConfiguration.getPrimaryPublicId()));
        return analysisProfile;
    }

    public static List<@NonNull AnalysisProfile> getEmbeddedAnalysisProfiles(ProjectStorageSystem projectStorageSystem) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return projectConfiguration.getCodeScopes().stream().map(codeScope -> {
            CCSMAssert.isNotNull((Object)codeScope.getEmbeddedProfile(), (String)"expected embedded profile for code scope %s".formatted(codeScope));
            return codeScope.getEmbeddedProfile();
        }).toList();
    }

    public static void createDefaultAnalysisProfiles(GlobalStorageSystem globalStorageSystem) throws StorageException, MigrationException {
        if (EFeatureToggle.DISABLE_DEFAULT_ANALYSIS_PROFILES_CREATION.isEnabled()) {
            return;
        }
        AnalysisProfileUtils.insertDefaultAnalysisProfiles(globalStorageSystem, LOGGER);
        if (EFeatureToggle.AUDIT_FEATURES.isEnabled()) {
            AnalysisProfileUtils.importAdditionalAnalysisProfiles(globalStorageSystem, ResourceUtils.listResourcesRecursively(AnalysisProfileUtils.class, (String)AUDIT_ANALYSIS_PROFILE_DIRECTORY_NAME), "", "Default Profile");
        }
        AnalysisProfileUtils.importAdditionalAnalysisProfiles(globalStorageSystem, ResourceUtils.listResourcesRecursively(AnalysisProfileUtils.class, (String)DEFAULT_ANALYSIS_PROFILE_DIRECTORY_NAME), "", "Default Profile");
    }

    public static AnalysisGroup getAnalysisGroupByName(AnalysisProfile analysisProfile, String qualityIndicatorName, String analysisGroupName) {
        Optional<QualityIndicator> qualityIndicator = analysisProfile.getQualityIndicators().stream().filter(indicator -> indicator.getName().equals(qualityIndicatorName)).findFirst();
        return qualityIndicator.flatMap(indicator -> indicator.getGroups().stream().filter(group -> group.getName().equals(analysisGroupName)).findFirst()).orElse(null);
    }

    public static void addNewAnalysisProfileVersion(AnalysisProfileVersionedIndex profileVersionIndex, AnalysisProfileIndex analysisProfileIndex, AnalysisProfile analysisProfile, String editedBy, String comment, GlobalStorageSystem globalStorageSystem) throws StorageException {
        analysisProfileIndex.setProfile(analysisProfile);
        profileVersionIndex.addNewAnalysisProfileVersion(analysisProfile, editedBy, comment, globalStorageSystem);
    }

    public static void updateCurrentProfileSilently(AnalysisProfileVersionedIndex versionedProfileIndex, AnalysisProfileIndex profileIndex, AnalysisProfile analysisProfile) throws StorageException {
        profileIndex.setProfile(analysisProfile);
        versionedProfileIndex.updateCurrentProfileSilently(analysisProfile.getName(), analysisProfile);
    }

    public static List<QualityIndicator> getQualityIndicators(List<AnalysisProfile> analysisProfiles) {
        return analysisProfiles.stream().flatMap(profile -> profile.getQualityIndicators().stream()).toList();
    }

    public static CodeScopeAware<List<QualityIndicator>> getConfiguredQualityIndicatorsPerCodeScope(IndexLayer indexLayer, ProjectConfiguration projectConfiguration) throws StorageException {
        CodeScopeAware qualityIndicatorsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScope : projectConfiguration.getCodeScopeNames()) {
            String analysisProfileName;
            AnalysisProfileIndex profileIndex = (AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class);
            AnalysisProfile profile = profileIndex.getProfile(analysisProfileName = ProjectConfigurationUtils.getAnalysisProfileNameForProject((IProjectId)projectConfiguration.getInternalId(), (IndexLayer)indexLayer, (CodeScopeName)codeScope));
            if (profile == null) {
                throw new StorageException(String.format("Analysis Profile [%s] in code scope [%s] does not exist.", analysisProfileName, codeScope));
            }
            qualityIndicatorsPerCodeScope.setValue(codeScope, (Object)profile.getQualityIndicators());
        }
        return qualityIndicatorsPerCodeScope;
    }

    public static List<QualityIndicator> getConfiguredQualityIndicators(IndexLayer indexLayer, ProjectConfiguration projectConfiguration) throws StorageException {
        return AnalysisProfileUtils.getConfiguredQualityIndicatorsPerCodeScope(indexLayer, projectConfiguration).getValues().stream().flatMap(Collection::stream).toList();
    }

    public static List<String> getAllEnabledOptions(AnalysisProfile profile) {
        return profile.getQualityIndicators().stream().flatMap(qualityIndicator -> qualityIndicator.getGroups().stream()).filter(analysisGroup -> null != analysisGroup.getOptions()).flatMap(group -> group.getOptions().entrySet().stream()).filter(entry -> !Objects.equals(entry.getValue(), "OFF")).map(Map.Entry::getKey).toList();
    }

    private AnalysisProfileUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

