/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools.message;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.configuration.tools.message.IMessageManager;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;

public abstract class RuleBasedMessageManagerBase
implements IMessageManager {
    private final Map<String, Rule> ruleIdToRule;
    private final String findingCategory;

    protected RuleBasedMessageManagerBase(String findingCategory, String ... rulesJsonFilePaths) throws ProjectConfigurationException {
        this.findingCategory = findingCategory;
        this.ruleIdToRule = new HashMap<String, Rule>();
        for (String rulesJsonFilePath : rulesJsonFilePaths) {
            this.loadRules(rulesJsonFilePath);
        }
    }

    private void loadRules(String rulesJsonFilePath) throws ProjectConfigurationException {
        try {
            Rule[] rules;
            String rulesFileContent = Resource.of(RuleBasedMessageManagerBase.class, (String)rulesJsonFilePath).getContent();
            for (Rule rule : rules = (Rule[])JsonUtils.deserializeFromJsonWithNullCheck((String)rulesFileContent, Rule[].class)) {
                this.ruleIdToRule.put(rule.id, rule);
            }
        }
        catch (ConQATException | ResourceException e) {
            throw new ProjectConfigurationException(e);
        }
    }

    public Collection<Rule> getRules() {
        return this.ruleIdToRule.values();
    }

    private Rule getRule(String ruleId) {
        return this.ruleIdToRule.get(ruleId);
    }

    @Override
    public boolean hasRule(String ruleId) {
        return this.ruleIdToRule.containsKey(ruleId);
    }

    @Override
    public String getFindingCategoryName() {
        return this.findingCategory;
    }

    @Override
    public String getFindingsGroupNameFor(String ruleId) {
        return this.getFindingsGroupNameFor(this.getRule(ruleId));
    }

    @Override
    public String getReadableNameFor(String ruleId) {
        return this.getRule((String)ruleId).type;
    }

    public String getDescription(String ruleId) {
        return this.getRule((String)ruleId).description;
    }

    public abstract String getFindingsGroupNameFor(Rule var1);

    public abstract String getAnalysisGroupNameFor(Rule var1);

    public abstract EFindingEnablement getFindingEnablementFor(Rule var1);

    public static String getFindingsDescriptorNameFor(Rule rule) {
        return rule.message + " (" + rule.id + ")";
    }

    public static String getFindingsDescriptorNameForAsMarkdown(Rule rule) {
        return rule.message + " \\(" + rule.id + "\\)";
    }
}

