/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CDataflowUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public class NullCheckBeforeDereferenceFilter
implements IFalsePositiveFilter {
    private static final TokenPattern GENERAL_NULL_CHECK_PATTERNS = new TokenPattern().alternative(new Object[]{new TokenPattern().notPrecededBy(EnumSet.of(ETokenType.DOT, ETokenType.ARROWSTAR, ETokenType.MULT)).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).alternative(new Object[]{ETokenType.NEQ, ETokenType.EQ, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ, ETokenType.EQEQEQ}).sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN}), new TokenPattern().sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN}).alternative(new Object[]{ETokenType.NEQ, ETokenType.EQ, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ, ETokenType.EQEQEQ}).notPrecededBy((Object)ETokenType.MULT).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).notFollowedBy(EnumSet.of(ETokenType.DOT, ETokenType.ARROWSTAR)), new TokenPattern().repeated(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).repeated(new Object[]{ETokenType.RPAREN}).sequence(new Object[]{ETokenType.QUESTION}), new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.SAFECALL_OPERATOR}), new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).alternative(new Object[]{ETokenType.ANDAND, ETokenType.OROR})});

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo node) {
        Integer offsetOfFirstDereference = statement.getReadWriteInfo().getDereferenceInfo().getDereferenceOffset(variable);
        if (offsetOfFirstDereference == null) {
            return false;
        }
        if (NullCheckBeforeDereferenceFilter.hasConditionNullCheck(statement.getCondition(), variable)) {
            return true;
        }
        List lambdaTokens = CollectionUtils.map(statement.getLambdas(), NullCheckBeforeDereferenceFilter::getCfgTokens);
        if (lambdaTokens.stream().anyMatch(tokensInLambda -> NullCheckBeforeDereferenceFilter.hasExpressionNullCheck(tokensInLambda, variable, offsetOfFirstDereference))) {
            return true;
        }
        List<String> paramIdentifiers = NullCheckBeforeDereferenceFilter.getLambdaParameters(statement);
        if (!paramIdentifiers.isEmpty() && paramIdentifiers.contains(variable)) {
            return true;
        }
        List<IToken> statementTokensWithoutLambda = NullCheckBeforeDereferenceFilter.filterLambdaTokensFrom(statement.getTokens(), lambdaTokens);
        return NullCheckBeforeDereferenceFilter.hasExpressionNullCheck(statementTokensWithoutLambda, variable, offsetOfFirstDereference);
    }

    private static @NonNull List<IToken> filterLambdaTokensFrom(List<IToken> statementTokens, List<List<IToken>> lambdaTokens) {
        ArrayList<IToken> tokensWithoutLambda = new ArrayList<IToken>(statementTokens);
        lambdaTokens.forEach(tokensWithoutLambda::removeAll);
        return tokensWithoutLambda;
    }

    private static List<IToken> getCfgTokens(ControlFlowGraph controlFlowGraph) {
        return controlFlowGraph.listDepthFirst().stream().flatMap(node -> node.getTokens().stream()).toList();
    }

    private static boolean hasConditionNullCheck(Condition condition, String variableName) {
        return condition != null && condition.getNullCheckedVariables().contains(variableName);
    }

    private static boolean hasExpressionNullCheck(List<IToken> tokens, String variableName, int offsetOfFirstDereference) {
        return GENERAL_NULL_CHECK_PATTERNS.findAll(tokens).stream().filter(match -> variableName.equals(((IToken)match.groupTokens(0).getFirst()).getText())).anyMatch(match -> offsetOfFirstDereference >= ((IToken)match.groupTokens(0).getFirst()).getOffset());
    }

    private static List<String> getLambdaParameters(ControlFlowNode statement) {
        return statement.getLambdaEntries().stream().flatMap(node -> node.getTokens().stream()).filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).toList();
    }
}

