/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CsDiscardVariableDeadStoreFilter
implements IFalsePositiveFilter {
    private static final Predicate<String> IS_METHOD_PARAMETER_DISCARD = Pattern.compile("_+|_\\d+").asMatchPredicate();

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        return CsDiscardVariableDeadStoreFilter.isDiscard(variable) || CsDiscardVariableDeadStoreFilter.isMethodParameterDiscard(variable, statement, controlFlowGraph);
    }

    private static boolean isDiscard(String variable) {
        return variable.equals("_");
    }

    private static boolean isMethodParameterDiscard(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph) {
        return CsDiscardVariableDeadStoreFilter.variableIsMethodParameter(statement, controlFlowGraph) && IS_METHOD_PARAMETER_DISCARD.test(variable);
    }

    private static boolean variableIsMethodParameter(ControlFlowNode statement, ControlFlowGraph controlFlowGraph) {
        return statement == controlFlowGraph.getRoot();
    }
}

