/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.nullpointer;

import com.google.common.collect.ImmutableMap;
import com.teamscale.index.dataflow.DataFlowGraph;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.DataflowFindingsCreatorBase;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.EnumLatticeBase;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.PathSensitiveAnalysisState;
import com.teamscale.index.dataflow.PathSensitiveDataflowAnalysisBase;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.nullpointer.NullPointerFindingsCreationUtils;
import com.teamscale.index.dataflow.nullpointer.NullPointerLattice;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class NullPointerFindingCreationAnalysis
extends PathSensitiveDataflowAnalysisBase<EFindingReportedState> {
    public static final String FINDING_CATEGORY = "Dataflow";
    public static final String FINDINGS_GROUP = "Null pointer dereference";
    private static final EnumLatticeBase<EFindingReportedState> LATTICE = new EnumLatticeBase<EFindingReportedState>(EFindingReportedState.class){

        @Override
        protected void addNonTrivialCombinations(TwoDimHashMap<EFindingReportedState, EFindingReportedState, EFindingReportedState> leastUpperBound) {
        }
    };
    private final DataflowAnalysisResult<String, NullPointerLattice.ENullness> initialAnalysisResult;
    private final List<IFalsePositiveFilter> filters;
    private final List<ShallowEntity> fileEntities;
    protected final List<IndexFinding> findings = new ArrayList<IndexFinding>();
    private final ImmutableMap<String, EFindingReportedState> infeasibleState = ImmutableMap.of();

    public NullPointerFindingCreationAnalysis(DataflowAnalysisResult<String, NullPointerLattice.ENullness> result, List<ShallowEntity> fileEntities, List<IFalsePositiveFilter> filters) {
        this.initialAnalysisResult = result;
        this.filters = filters;
        this.fileEntities = fileEntities;
    }

    @Override
    protected ImmutableMap<String, EFindingReportedState> transformValues(ControlFlowNode controlFlowNode, PathSensitiveAnalysisState<EFindingReportedState> state) throws ConQATException {
        if (controlFlowNode.continuesWithLoopReturnEdge()) {
            return this.infeasibleState;
        }
        HashMap<String, EFindingReportedState> newState = new HashMap<String, EFindingReportedState>((Map<String, EFindingReportedState>)state.getValueState());
        UnmodifiableMap dataflowAnalysisFactsForNode = this.initialAnalysisResult.getFacts().getSecondMap((Object)controlFlowNode);
        for (String varName : controlFlowNode.getReadWriteInfo().getDereferenceInfo().getDereferencedVariables()) {
            NullPointerLattice.ENullness nullness = (NullPointerLattice.ENullness)((Object)dataflowAnalysisFactsForNode.get((Object)varName));
            if (state.getValueState().get((Object)varName) == EFindingReportedState.NOT_REPORTED && this.isInterestingFinding(varName, nullness, controlFlowNode, this.initialAnalysisResult.getFacts())) {
                IndexFinding finding = this.createFinding(controlFlowNode, varName);
                this.findings.add(finding);
                newState.put(varName, EFindingReportedState.REPORTED);
                continue;
            }
            if (!NullPointerFindingCreationAnalysis.resetsReportingState(nullness)) continue;
            newState.put(varName, EFindingReportedState.NOT_REPORTED);
        }
        return ImmutableMap.copyOf(newState);
    }

    private static boolean resetsReportingState(NullPointerLattice.ENullness nullness) {
        return nullness == NullPointerLattice.ENullness.NON_NULL;
    }

    private boolean isInterestingFinding(String varName, NullPointerLattice.ENullness nullness, ControlFlowNode controlFlowNode, TwoDimHashMap<ControlFlowNode, String, NullPointerLattice.ENullness> nullnessFactsInOtherNodes) throws ConQATException {
        return NullPointerFindingsCreationUtils.isInterestingNullness(nullness, varName, controlFlowNode, nullnessFactsInOtherNodes) && !DataflowFindingsCreatorBase.isFilteredFinding(varName, controlFlowNode, this.controlFlowGraph, this.fileEntities, this.element, this.filters);
    }

    private IndexFinding createFinding(ControlFlowNode controlFlowNode, String varName) {
        List<IToken> nodeTokens = controlFlowNode.getTokens();
        TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(nodeTokens, this.element, this.offsetTransformer, this.rawLineOffsetConverter);
        return new IndexFinding(FINDINGS_GROUP, FINDING_CATEGORY, NullPointerFindingsCreationUtils.createMessage(varName), (ElementLocation)location);
    }

    @Override
    protected boolean isFeasible(PathSensitiveAnalysisState<EFindingReportedState> transformationResult) {
        return super.isFeasible(transformationResult) && transformationResult.getValueState() != this.infeasibleState;
    }

    @Override
    protected IDataFlowGraph createDataFlowGraph(ControlFlowGraph controlFlowGraph) {
        return new DataFlowGraph(controlFlowGraph);
    }

    @Override
    protected IDataflowFindingsCreator<DataflowAnalysisResult<String, EFindingReportedState>> createFindingsCreator(List<IFalsePositiveFilter> filters) {
        return IDataflowFindingsCreator.createNoOpFindingCreator();
    }

    @Override
    protected EDirection getDirection() {
        return EDirection.FORWARD;
    }

    @Override
    protected ILattice<EFindingReportedState> getLattice() {
        return LATTICE;
    }

    public static enum EFindingReportedState {
        NOT_REPORTED,
        REPORTED;

    }
}

