/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphParameter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MethodCallReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String methodName;
    private String methodContainerName;
    private boolean isStaticCall;
    private String callsiteMethodName;
    private final PairList<MethodCallInputValueReference, MethodCallReturnValueReference> unnamedParameters = new PairList();
    private final Map<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>> namedParameters = new HashMap<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>>();
    private TaintGraphReferenceBase unnamedAssignee;
    private Pair<String, TaintGraphReferenceBase> namedReturnParameter;
    private final Map<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>> fieldReferences = new HashMap<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>>();
    private int cfgNodeId;
    private TaintGraphReferenceBase methodContainerObjectReference;

    public TreeSet<TaintGraphReferenceBase> getAllInfluencingParameters() {
        TreeSet<TaintGraphReferenceBase> influences = new TreeSet<TaintGraphReferenceBase>();
        influences.addAll(this.getUnnamedParameters().extractFirstList());
        influences.addAll(this.getNamedParameters().values().stream().map(ImmutablePair::getFirst).collect(Collectors.toList()));
        if (this.getMethodContainerObjectReference() != null) {
            influences.add(this.getMethodContainerObjectReference());
        }
        return influences;
    }

    public List<TaintGraphReferenceBase> getCallerInputParametersFor(List<TaintGraphReferenceBase> calleeInputs) {
        ArrayList<TaintGraphReferenceBase> callerInputs = new ArrayList<TaintGraphReferenceBase>(calleeInputs.size());
        block6: for (TaintGraphReferenceBase calleeInput : calleeInputs) {
            switch (calleeInput.getType()) {
                case SOURCE: {
                    continue block6;
                }
                case RFC_SOURCE: {
                    continue block6;
                }
                case PARAMETER: {
                    String calleeInputName = calleeInput.getReferenceName();
                    int calleeInputIndex = ((TaintGraphParameter)calleeInput).getParameterIndex();
                    Pair<MethodCallInputValueReference, MethodCallReturnValueReference> callerInputRef = this.getNamedParameters().get(calleeInputName);
                    if (callerInputRef != null) {
                        callerInputs.add((TaintGraphReferenceBase)callerInputRef.getFirst());
                        continue block6;
                    }
                    if (this.getUnnamedParameters().size() <= calleeInputIndex) continue block6;
                    callerInputs.add((TaintGraphReferenceBase)this.getUnnamedParameters().getFirst(calleeInputIndex));
                    continue block6;
                }
                case FIELD: {
                    if (this.getFieldReferences().get(calleeInput.getReferenceName()) == null) continue block6;
                    callerInputs.add((TaintGraphReferenceBase)this.getFieldReferences().get(calleeInput.getReferenceName()).getFirst());
                    continue block6;
                }
            }
            CCSMAssert.fail((String)("unhandled parameter type in MethodCallReference getCallerInputs: " + calleeInput.getClass().getSimpleName()));
        }
        return callerInputs;
    }

    public String getCalledMethodIdentifier() {
        if (this.getMethodContainerName() != null) {
            return this.getMethodContainerName() + "." + this.getMethodName();
        }
        return "." + this.getMethodName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodCallReference)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MethodCallReference otherCall = (MethodCallReference)obj;
        return this.getMethodName().equals(otherCall.getMethodName()) && this.getCallsiteMethodName().equals(otherCall.getCallsiteMethodName()) && Objects.equals(this.getMethodContainerName(), otherCall.getMethodContainerName()) && Objects.equals(this.getMethodContainerObjectReference(), otherCall.getMethodContainerObjectReference()) && this.getFieldReferences().equals(otherCall.getFieldReferences()) && this.getNamedParameters().equals(otherCall.getNamedParameters()) && this.getUnnamedParameters().equals(otherCall.getUnnamedParameters()) && Objects.equals(this.getNamedReturnParameter(), otherCall.getNamedReturnParameter()) && Objects.equals(this.getUnnamedAssignee(), otherCall.getUnnamedAssignee());
    }

    public int hashCode() {
        return Objects.hashCode(this.getMethodName()) + Objects.hashCode(this.getCallsiteMethodName()) + Objects.hashCode(this.getMethodContainerName()) + Objects.hashCode(this.getMethodContainerObjectReference()) + Objects.hashCode(this.getFieldReferences()) + Objects.hashCode(this.getNamedParameters()) + Objects.hashCode(this.getNamedReturnParameter()) + Objects.hashCode(this.getUnnamedParameters()) + Objects.hashCode(this.getUnnamedAssignee()) + Objects.hash(this.getCfgNodeId());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodContainerName() {
        return this.methodContainerName;
    }

    public void setMethodContainerName(String methodContainerName) {
        this.methodContainerName = methodContainerName;
    }

    public boolean isStaticCall() {
        return this.isStaticCall;
    }

    public void setStaticCall(boolean isStaticCall) {
        this.isStaticCall = isStaticCall;
    }

    public String getCallsiteMethodName() {
        return this.callsiteMethodName;
    }

    public void setCallsiteMethodName(String callsiteMethodName) {
        this.callsiteMethodName = callsiteMethodName;
    }

    public PairList<MethodCallInputValueReference, MethodCallReturnValueReference> getUnnamedParameters() {
        return this.unnamedParameters;
    }

    public Map<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>> getNamedParameters() {
        return this.namedParameters;
    }

    public TaintGraphReferenceBase getUnnamedAssignee() {
        return this.unnamedAssignee;
    }

    public void setUnnamedAssignee(TaintGraphReferenceBase unnamedAssignee) {
        this.unnamedAssignee = unnamedAssignee;
    }

    public Pair<String, TaintGraphReferenceBase> getNamedReturnParameter() {
        return this.namedReturnParameter;
    }

    public void setNamedReturnParameter(Pair<String, TaintGraphReferenceBase> namedReturnParameter) {
        this.namedReturnParameter = namedReturnParameter;
    }

    public Map<String, Pair<MethodCallInputValueReference, MethodCallReturnValueReference>> getFieldReferences() {
        return this.fieldReferences;
    }

    public int getCfgNodeId() {
        return this.cfgNodeId;
    }

    public void setCfgNodeId(int cfgNodeId) {
        this.cfgNodeId = cfgNodeId;
    }

    public TaintGraphReferenceBase getMethodContainerObjectReference() {
        return this.methodContainerObjectReference;
    }

    public void setMethodContainerObjectReference(TaintGraphReferenceBase methodContainerObjectReference) {
        this.methodContainerObjectReference = methodContainerObjectReference;
    }

    public String toString() {
        return "Call of " + this.getMethodName() + " in " + this.getCalledMethodIdentifier();
    }
}

