/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.DependencyAnalysisFactory;
import com.teamscale.index.dependencies.ITypeExtractor;
import com.teamscale.index.dependencies.TypeDeltaIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeInfo;
import com.teamscale.index.dependencies.cpp.CppTypeExtractor;
import com.teamscale.index.dependencies.type.Type;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;

public class TypeIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TypeDeltaIndex typeDeltaIndex;
    @StepParameter(value="perform-case-sensitive-header-resolution", optional=true)
    private boolean performCaseSensitiveHeaderResolution = false;
    @StepParameter(value="find-dependencies-in-excluded-code", optional=true)
    private boolean findCppDependenciesInExcludedCode = false;

    public void execute() throws StorageException {
        List deletedKeys = this.contentDelta.getDeletedKeysAsStrings();
        if (!deletedKeys.isEmpty()) {
            this.typeIndex.removeFiles(deletedKeys);
            this.typeDeltaIndex.removeEntries(deletedKeys);
        }
        HashSet<String> pathsToRecompute = new HashSet<String>();
        for (String uniformPath : this.contentDelta.getAllKeysAsStrings()) {
            ITypeExtractor typeExtractor = DependencyAnalysisFactory.createTypeExtractor(ELanguage.fromPath((String)uniformPath), this.contentIndex);
            if (UniformPathUtils.isArchitectureFile((String)uniformPath)) continue;
            pathsToRecompute.addAll(typeExtractor.getPathsToRecompute(uniformPath, this.contentIndex));
        }
        pathsToRecompute.removeAll(new HashSet(this.contentDelta.getDeletedKeysAsStrings()));
        PairList typeIndexValuesToSet = new PairList();
        PairList typeDeltaIndexValuesToSet = new PairList();
        for (TokenElementInfo value : this.contentIndex.getTokenElements(new ArrayList<String>(pathsToRecompute))) {
            this.extractTypes(value, (PairList<String, TypeInfo>)typeIndexValuesToSet, (PairList<String, String>)typeDeltaIndexValuesToSet);
        }
        this.typeIndex.setValues((PairList<String, TypeInfo>)typeIndexValuesToSet);
        this.typeDeltaIndex.setEntries((PairList<String, String>)typeDeltaIndexValuesToSet);
    }

    private void extractTypes(TokenElementInfo tokenElement, PairList<String, TypeInfo> typeIndexValuesToSet, PairList<String, String> typeDeltaIndexValuesToSet) {
        String uniformPath1 = tokenElement.getUniformPath();
        if (UniformPathUtils.isArchitectureFile((String)uniformPath1)) {
            return;
        }
        String uniformPath = tokenElement.getUniformPath();
        String content = tokenElement.getText();
        ELanguage language = tokenElement.getLanguage();
        ITypeExtractor typeExtractor = DependencyAnalysisFactory.createTypeExtractor(language, this.contentIndex);
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
            ((CppTypeExtractor)typeExtractor).setPerformCaseSensitiveHeaderResolution(this.performCaseSensitiveHeaderResolution);
            ((CppTypeExtractor)typeExtractor).setFindCppDependenciesInExcludedCode(this.findCppDependenciesInExcludedCode);
        }
        try {
            String hash = ContainerInfo.calculateContentDigest(content);
            typeDeltaIndexValuesToSet.add((Object)uniformPath, (Object)hash);
            List<Type> types = typeExtractor.extractTypes(uniformPath, content, language);
            typeIndexValuesToSet.add((Object)uniformPath, (Object)new TypeInfo(types));
        }
        catch (ConQATException e) {
            LOGGER.warn("Failed to extract types for '" + uniformPath + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

