/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.dart;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.dart.DartPackagePathsIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.yaml.snakeyaml.Yaml;

public class DartPubSpecPathsSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_SRC_LIB_FOLDER = "lib";
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta delta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex inputIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private DartPackagePathsIndex dartPackagePathsIndex;

    public void execute() throws StorageException {
        List<String> addedOrChangedPubspecYamlFiles = DartPubSpecPathsSynchronizer.filterPubSpecFiles(this.delta.getAddedOrChangedKeysAsStrings());
        this.handlePubspecYamlDeletions();
        try {
            PairList packageNameToUniformPath = new PairList();
            for (String path : addedOrChangedPubspecYamlFiles) {
                Object object;
                BasicTokenElementInfo tokenElement = this.inputIndex.getTokenElement(path);
                if (tokenElement == null) {
                    LOGGER.warn("Encountered file without content, skipping: {}", (Object)path);
                    continue;
                }
                String fileContent = tokenElement.getText();
                Map<String, Object> pubSpec = DartPubSpecPathsSynchronizer.parseYamlFile(tokenElement.getUniformPath(), fileContent);
                if (pubSpec.get("name") == null || !((object = pubSpec.get("name")) instanceof String)) continue;
                String name = (String)object;
                packageNameToUniformPath.add((Object)name, (Object)path.replace("pubspec.yaml", DEFAULT_SRC_LIB_FOLDER));
            }
            this.dartPackagePathsIndex.storePackageNamesForUniformPaths((PairList<String, String>)packageNameToUniformPath);
        }
        catch (ConQATException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handlePubspecYamlDeletions() throws StorageException {
        List<String> deletedPubspecYamlFiles = DartPubSpecPathsSynchronizer.filterPubSpecFiles(this.delta.getDeletedKeysAsStrings());
        this.dartPackagePathsIndex.removeStoredPackageNamesForPaths(deletedPubspecYamlFiles.stream().map(pubSpecPath -> pubSpecPath.replace("pubspec.yaml", DEFAULT_SRC_LIB_FOLDER)).toList());
    }

    private static Map<String, Object> parseYamlFile(String path, String fileContent) {
        try {
            return (Map)new Yaml().load(fileContent);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing yaml file: {}", (Object)path, (Object)e);
            return new HashMap<String, Object>();
        }
    }

    private static List<String> filterPubSpecFiles(List<String> addedOrChangedKeysAsStrings) {
        return CollectionUtils.filter(addedOrChangedKeysAsStrings, uniformPath -> UniformPathUtils.getElementName((String)uniformPath).equals("pubspec.yaml"));
    }
}

