/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.type;

import java.util.ArrayList;
import java.util.Arrays;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="pattern-matching-cache", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={String.class})
public class PatternMatchingCacheIndex
implements IProjectIndex {
    private static final String KEY_SEPARATOR = "#!#";
    private static final byte[] FALSE = new byte[]{0};
    private static final byte[] TRUE = new byte[]{1};
    private final ConvenientStore store;

    public PatternMatchingCacheIndex(IStore store) {
        this.store = new ConvenientStore(store);
    }

    public TwoDimHashMap<String, String, Boolean> getAllEntries() throws StorageException {
        TwoDimHashMap entries = new TwoDimHashMap();
        PairList storeEntries = this.store.getEntriesStartingWith("");
        for (int i = 0; i < storeEntries.size(); ++i) {
            String key = StringUtils.bytesToString((byte[])((byte[])storeEntries.getFirst(i)));
            Boolean matchResult = PatternMatchingCacheIndex.convertValue((byte[])storeEntries.getSecond(i));
            Pair keySplit = StringUtils.splitAtFirst((String)key, (String)KEY_SEPARATOR);
            entries.putValue((Object)((String)keySplit.getFirst()), (Object)((String)keySplit.getSecond()), (Object)matchResult);
        }
        return entries;
    }

    private static Boolean convertValue(byte[] value) {
        CCSMAssert.isTrue((value.length == 1 ? 1 : 0) != 0, (String)("Unexpected value format " + Arrays.toString(value)));
        return value[0] == TRUE[0];
    }

    public void addEntries(TwoDimHashMap<String, String, Boolean> entries) throws StorageException {
        PairList keysValues = new PairList();
        for (String string : entries.getFirstKeys()) {
            for (String pattern : entries.getSecondKeys((Object)string)) {
                if (pattern.isEmpty()) continue;
                String key = PatternMatchingCacheIndex.makeKey(string, pattern);
                Boolean match = (Boolean)entries.getValue((Object)string, (Object)pattern);
                keysValues.add((Object)key, (Object)(match != false ? TRUE : FALSE));
            }
        }
        this.store.putWithStrings(keysValues);
    }

    private static String makeKey(String string, String pattern) {
        return string + KEY_SEPARATOR + pattern;
    }

    public void removeEntries(PairList<String, String> unusedEntries) throws StorageException {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (int i = 0; i < unusedEntries.size(); ++i) {
            keysToRemove.add(PatternMatchingCacheIndex.makeKey((String)unusedEntries.getFirst(i), (String)unusedEntries.getSecond(i)));
        }
        this.store.removeWithStrings(keysToRemove);
    }
}

