/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.commons.StreamUtils;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.external_storage.ExternalAnalysisSessionMetadata;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalStorageFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
class OutgoingExternalAnalysisSessionMetadata
implements IOutgoingExternalStorageFile {
    private final String targetPath;
    private final byte[] content;
    private final long contentSizeInBytes;

    private OutgoingExternalAnalysisSessionMetadata(String targetPath, byte[] content, long contentSizeInBytes) {
        this.targetPath = targetPath;
        this.content = content;
        this.contentSizeInBytes = contentSizeInBytes;
    }

    public static OutgoingExternalAnalysisSessionMetadata create(ExternalAnalysisSessionInfo session, IOutgoingExternalStorageFile outgoingArchive) throws IOException {
        try (ByteArrayOutputStream contentStream = new ByteArrayOutputStream();){
            long dataSize = StreamUtils.writeWithByteCounter((OutputStream)contentStream, stream -> stream.write(OutgoingExternalAnalysisSessionMetadata.createMetadata(session, outgoingArchive).serialize()));
            byte[] content = contentStream.toByteArray();
            OutgoingExternalAnalysisSessionMetadata outgoingExternalAnalysisSessionMetadata = new OutgoingExternalAnalysisSessionMetadata(OutgoingExternalAnalysisSessionMetadata.buildTargetPath(session), content, dataSize);
            return outgoingExternalAnalysisSessionMetadata;
        }
    }

    private static ExternalAnalysisSessionMetadata createMetadata(ExternalAnalysisSessionInfo session, IOutgoingExternalStorageFile outgoingArchive) {
        return new ExternalAnalysisSessionMetadata(outgoingArchive.getTargetPath(), session.getMessage());
    }

    private static String buildTargetPath(ExternalAnalysisSessionInfo session) {
        return session.getTargetStorage().orElseThrow(() -> new IllegalArgumentException("Session '%s' does not target external storage.".formatted(session.getMessage()))).uploadPathPrefix() + StringUtils.ensureEndsWith((String)"__metadata__", (String)"/") + "%s.json".formatted(session.getSessionId());
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getContentSizeInBytes() {
        return this.contentSizeInBytes;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }
}

