/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.commit_clustering;

import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.ListMap;
import org.jspecify.annotations.Nullable;

public abstract class CommitClusteringStrategyBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ListMap<String, CommitCluster> clusterCommits(ListMap<String, CommitDescriptor> codeCommits, ListMap<String, CommitAndPartition> uploadCommits) {
        ListMap commitClustersByBranch = new ListMap();
        for (Map.Entry entry : uploadCommits) {
            String branch = (String)entry.getKey();
            List uploadCommitsOnBranch = (List)entry.getValue();
            List codeCommitsOnBranch = (List)codeCommits.getCollectionOrEmpty((Object)branch);
            LinkedList sortedUploadCommitsOnBranch = uploadCommitsOnBranch.stream().sorted().collect(Collectors.toCollection(LinkedList::new));
            LinkedList sortedCodeCommitsOnBranch = codeCommitsOnBranch.stream().sorted().collect(Collectors.toCollection(LinkedList::new));
            List<CommitCluster> commitCluster = this.clusterCommitsOnBranch(sortedUploadCommitsOnBranch, sortedCodeCommitsOnBranch);
            LOGGER.trace("Clustered commits for branch {}: {}", (Object)branch, commitCluster);
            if (commitCluster == null) continue;
            commitClustersByBranch.addAll((Object)branch, commitCluster);
        }
        return commitClustersByBranch;
    }

    protected abstract @Nullable List<CommitCluster> clusterCommitsOnBranch(LinkedList<CommitAndPartition> var1, @Nullable LinkedList<CommitDescriptor> var2);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

