/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.tools.StoreModifierBase;
import com.teamscale.index.repository.committree.CachingBranchRenameHandler;
import com.teamscale.index.repository.committree.IBranchRenameHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.options.Option;
import org.jetbrains.annotations.VisibleForTesting;

public class ExternalAnalysisBranchRenamingModifier
extends StoreModifierBase {
    private static final Set<String> SUPPORTED_STORES = Set.of("external-architecture-uploads", "external-analysis-results", "external-analysis-session");
    private final StringTransformation branchMappings = new StringTransformation();
    private final Set<String> branchesToDelete = new HashSet<String>();
    private IBranchRenameHandler branchRenameHandler;

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        ExternalAnalysisBranchRenamingModifier.execute(ExternalAnalysisBranchRenamingModifier::new, (String[])args);
    }

    @Option(shortName=109, longName="branch-mapping", description="Mappings for changing the branches.\nFormat is \"<old_branch_pattern>:<replacement>\" where the <old_branch_pattern> is interpreted as regular expression.\nThe <replacement> may contain references to groups of the <old_branch_pattern>.\nThis allows dynamic renaming such as \"unwanted-prefix-(.*):$1\" which removes the \"unwanted-prefix-\" from any matching branch.\n")
    public void addBranchMapping(String remapping) throws ConQATException {
        String[] split = remapping.split(":");
        if (split.length == 2) {
            this.branchMappings.add(split[0], split[1]);
        } else {
            ExternalAnalysisBranchRenamingModifier.exitWithMessage((String)String.format("Incorrect branch mapping: \"%s\". Must be in the format: <old_branch_pattern>:<replacement>", remapping));
        }
    }

    @Option(shortName=100, longName="delete", description="Delete uploads based on the given branch")
    public void addBranchDeletion(String branch) {
        this.branchesToDelete.add(branch);
    }

    @Override
    protected Set<String> getChangedStoreNames() {
        return SUPPORTED_STORES;
    }

    @Override
    protected void modifyStore(String storeName, CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        ExternalAnalysisBranchRenamingModifier.printInfo((String)("Migrating store: " + storeName));
        IStoreMigrator migrator = ExternalAnalysisBranchRenamingModifier.getBranchMigrator(storeName);
        migrator.modifyStore(inputStore, outputStore, commitsByBranch, this.branchRenameHandler, (Set<String>)CollectionUtils.asUnmodifiable(this.branchesToDelete));
    }

    private static IStoreMigrator getBranchMigrator(String storeName) {
        return switch (storeName) {
            case "external-architecture-uploads" -> new CommitLayeringBranchLayerStoreMigrator();
            case "external-analysis-results" -> new ExternalAnalysisResulIndexMigrator();
            case "external-analysis-session" -> new ExternalAnalysisSessionStoreMigrator();
            default -> throw new UnsupportedOperationException("Unexpected store %s. Expected one of: %s".formatted(storeName, SUPPORTED_STORES));
        };
    }

    private static void logProgress(int count, int total, String message) {
        ExternalAnalysisBranchRenamingModifier.printInfo((String)String.format("(%s/%s) %s", count, total, message));
    }

    protected void initFromCommandLine(String[] args) {
        super.initFromCommandLine(args);
        ExternalAnalysisBranchRenamingModifier.exitIfTrue((!this.branchMappings.containsTransformations() && this.branchesToDelete.isEmpty() ? 1 : 0) != 0, (String)"No branch transformation or branch to delete provided");
        this.branchRenameHandler = new CachingBranchRenameHandler(this.branchMappings, (PairList<String, String>)new PairList());
    }

    @VisibleForTesting
    static ExternalAnalysisSessionInfo createInfoWithNewBranch(ExternalAnalysisSessionInfo info, String newBranch) {
        return info.newBuilder().withCommit(new CommitDescriptor(newBranch, info.getCommit().getTimestamp())).build();
    }

    private static interface IStoreMigrator {
        public void modifyStore(CompressingStore var1, CompressingStore var2, Map<String, List<ParentedCommitDescriptor>> var3, IBranchRenameHandler var4, Set<String> var5) throws StorageException;
    }

    private static class CommitLayeringBranchLayerStoreMigrator
    implements IStoreMigrator {
        private CommitLayeringBranchLayerStoreMigrator() {
        }

        @Override
        public void modifyStore(CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch, IBranchRenameHandler branchRenameHandler, Set<String> branchesToDelete) throws StorageException {
            int branchIndex = 1;
            int totalBranches = commitsByBranch.size();
            for (Map.Entry<String, List<ParentedCommitDescriptor>> branchWithCommits : commitsByBranch.entrySet()) {
                String branch = branchWithCommits.getKey();
                if (branchesToDelete.contains(branch)) {
                    ExternalAnalysisBranchRenamingModifier.logProgress(branchIndex++, totalBranches, "Removing branch: " + branch);
                    continue;
                }
                String renamedBranch = branchRenameHandler.renameBranch(branch);
                ExternalAnalysisBranchRenamingModifier.logProgress(branchIndex++, totalBranches, branch + " -> " + renamedBranch);
                List<ParentedCommitDescriptor> commits = branchWithCommits.getValue();
                int commitIndex = 1;
                int totalCommits = commits.size();
                for (ParentedCommitDescriptor commit : commits) {
                    ExternalAnalysisBranchRenamingModifier.logProgress(commitIndex++, totalCommits, "Commit");
                    IStore commitInputStore = new CommitLayeringBranchingLayer((IStore)inputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout()).openStore(HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
                    IStore commitOutputStore = new CommitLayeringBranchingLayer((IStore)outputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout()).openStore(HistoryAccessOption.readHeadWriteTimestamp((String)renamedBranch, (long)commit.getTimestamp()));
                    this.modifyCommit(branchRenameHandler, commitInputStore, commitOutputStore);
                }
            }
        }

        protected void modifyCommit(IBranchRenameHandler branchRenameHandler, IStore commitInputStore, IStore commitOutputStore) throws StorageException {
            StorageUtils.copyStore((IStore)commitInputStore, (IStore)commitOutputStore);
        }
    }

    private static class ExternalAnalysisResulIndexMigrator
    extends CommitLayeringBranchLayerStoreMigrator {
        private ExternalAnalysisResulIndexMigrator() {
        }

        @Override
        protected void modifyCommit(IBranchRenameHandler branchRenameHandler, IStore commitInputStore, IStore commitOutputStore) throws StorageException {
            super.modifyCommit(branchRenameHandler, commitInputStore, commitOutputStore);
            ExternalAnalysisResultIndex inputIndex = new ExternalAnalysisResultIndex(commitInputStore);
            ExternalAnalysisResultIndex outputIndex = new ExternalAnalysisResultIndex(commitOutputStore);
            ExternalAnalysisCommitInfo commitInfo = (ExternalAnalysisCommitInfo)((Object)inputIndex.getCommitInfo());
            commitInfo.setCommit(new CommitDescriptor(branchRenameHandler.renameBranch(commitInfo.getCommit().getBranchName()), commitInfo.getCommit().getTimestamp()));
            outputIndex.setCommitInfo(commitInfo);
        }
    }

    private static class ExternalAnalysisSessionStoreMigrator
    implements IStoreMigrator {
        private ExternalAnalysisSessionStoreMigrator() {
        }

        @Override
        public void modifyStore(CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch, IBranchRenameHandler branchRenameHandler, Set<String> branchesToDelete) throws StorageException {
            ExternalAnalysisImportSessionIndex inputIndex = new ExternalAnalysisImportSessionIndex((IStore)inputStore);
            ExternalAnalysisImportSessionIndex outputIndex = new ExternalAnalysisImportSessionIndex((IStore)outputStore);
            Collection<String> sessionIds = inputIndex.getAllSessionIds();
            int total = sessionIds.size();
            int count = 1;
            for (String id : sessionIds) {
                Optional<ExternalAnalysisSessionInfo> opt = inputIndex.getSessionInfo(id);
                if (opt.isEmpty()) continue;
                ExternalAnalysisSessionInfo info = opt.get();
                String branchName = info.getCommit().getBranchName();
                if (branchesToDelete.contains(branchName)) {
                    ExternalAnalysisBranchRenamingModifier.logProgress(count++, total, "Removing upload to " + branchName);
                    continue;
                }
                Set<String> paths = inputIndex.getUniformPathsInSession(info);
                Map<String, ExternalAnalysisImportInfos> importInfos = inputIndex.getImportInfos(info, paths);
                String renamedBranch = branchRenameHandler.renameBranch(branchName);
                if (!Objects.equals(branchName, renamedBranch)) {
                    ExternalAnalysisBranchRenamingModifier.logProgress(count++, total, branchName + " -> " + renamedBranch);
                    outputIndex.insertImportInfos(ExternalAnalysisBranchRenamingModifier.createInfoWithNewBranch(info, renamedBranch), importInfos.values());
                    continue;
                }
                ++count;
                outputIndex.insertImportInfos(info, importInfos.values());
            }
        }
    }
}

