/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import eu.cqse.check.framework.core.registry.Guideline;
import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.FindingsSummaryGuidelineInfo;
import org.conqat.engine.index.shared.FindingsSummaryGuidelineRuleCategoryInfo;
import org.conqat.engine.index.shared.FindingsSummaryGuidelineRuleInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class GuidelineSummaryCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<RulesetInfo, CounterSet<ETrafficLightColor>> rulesCounter;
    private final FindingsCalculationInfo calculationInfo;
    private final boolean reportRulesWithoutFindings;

    private GuidelineSummaryCalculator(FindingsCalculationInfo calculationInfo, Map<RulesetInfo, CounterSet<ETrafficLightColor>> rulesCounter, boolean reportRulesWithoutFindings) {
        this.calculationInfo = calculationInfo;
        this.rulesCounter = rulesCounter;
        this.reportRulesWithoutFindings = reportRulesWithoutFindings;
    }

    public static List<FindingsSummaryGuidelineInfo> createGuidelineSummary(FindingsCalculationInfo calculationInfo, boolean reportRulesWithoutFindings, Map<RulesetInfo, CounterSet<ETrafficLightColor>> rulesCounter) {
        GuidelineSummaryCalculator calculator = new GuidelineSummaryCalculator(calculationInfo, rulesCounter, reportRulesWithoutFindings);
        return calculator.createGuidelineSummary();
    }

    private List<FindingsSummaryGuidelineInfo> createGuidelineSummary() {
        List<FindingsSummaryGuidelineInfo> guidelineInfos = Collections.emptyList();
        try {
            guidelineInfos = this.getGuidelineInfos();
        }
        catch (ProjectConfigurationException | StorageException e) {
            LOGGER.error("Could not determine analysis profile. Findings will not contain any guideline information.", e);
        }
        return guidelineInfos;
    }

    private static CodeScopeAware<Set<ELanguage>> getLanguagesPerCodeScope(FindingsCalculationInfo calculationInfo) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)calculationInfo.projectId(), (IndexLayer)calculationInfo.indexLayer());
        CodeScopeAware analysisProfilePerScope = projectConfiguration.getAnalysisProfilePerScope((AnalysisProfileIndex)calculationInfo.indexLayer().openGlobalIndex(AnalysisProfileIndex.class));
        return analysisProfilePerScope.map(AnalysisProfile::getLanguages);
    }

    private List<FindingsSummaryGuidelineInfo> getGuidelineInfos() throws ProjectConfigurationException, StorageException {
        HashMap<Set<ELanguage>, CounterSet<String>> numberOfEnabledChecksPerScopePerRule = new HashMap<Set<ELanguage>, CounterSet<String>>();
        CodeScopeAware<Set<ELanguage>> languagesPerCodeScope = GuidelineSummaryCalculator.getLanguagesPerCodeScope(this.calculationInfo);
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)this.calculationInfo.projectStorageSystem().openProjectIndex(FindingsSchemaIndex.class, null);
        for (Map.Entry entry : languagesPerCodeScope) {
            Set languages = (Set)entry.getValue();
            FindingsSchema findingsSchema = findingsSchemaIndex.getFindingsSchema((CodeScopeName)entry.getKey());
            if (findingsSchema == null) continue;
            numberOfEnabledChecksPerScopePerRule.put(languages, GuidelineSummaryCalculator.calculateNumberOfEnabledChecksPerGuidelineRule(languages, findingsSchema));
        }
        CounterSet<String> numberOfAvailableChecksPerRule = this.calculateNumberOfAvailableChecksPerGuidelineRule();
        return this.getGuidelineInfosFromTSV(numberOfEnabledChecksPerScopePerRule, numberOfAvailableChecksPerRule);
    }

    private Set<ELanguage> getLanguagesForAllProfiles(ProjectConfiguration projectConfiguration) throws StorageException {
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)this.calculationInfo.indexLayer().openGlobalIndex(AnalysisProfileIndex.class);
        HashSet<ELanguage> languages = new HashSet<ELanguage>();
        for (String analysisProfileName : projectConfiguration.getAnalysisProfileNames()) {
            AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
            if (analysisProfile == null) {
                LOGGER.error("Analysis profile not found: {}", (Object)analysisProfileName);
                continue;
            }
            languages.addAll((Collection<ELanguage>)analysisProfile.getLanguages());
        }
        return languages;
    }

    private List<FindingsSummaryGuidelineInfo> getGuidelineInfosFromTSV(Map<Set<ELanguage>, CounterSet<String>> numberOfEnabledChecksPerRule, CounterSet<String> numberOfAvailableChecksPerRule) {
        ArrayList<FindingsSummaryGuidelineInfo> guidelineInfos = new ArrayList<FindingsSummaryGuidelineInfo>();
        for (Guideline guideline : GuidelineMapping.getInstance().getGuidelines()) {
            ArrayList guidelineRuleInfos = new ArrayList();
            HashMap<String, FindingsSummaryGuidelineRuleCategoryInfo> guidelineRuleCategories = new HashMap<String, FindingsSummaryGuidelineRuleCategoryInfo>();
            for (RulesetInfo guidelineRule : GuidelineMapping.getInstance().getRuleNames(guideline.readableName())) {
                Optional<FindingsSummaryGuidelineRuleInfo> ruleInfo = this.calculateRuleSummary(numberOfEnabledChecksPerRule, numberOfAvailableChecksPerRule, guidelineRule, guidelineRuleCategories, guideline);
                ruleInfo.ifPresent(guidelineRuleInfos::add);
            }
            FindingsSummaryGuidelineInfo guidelineInfo = new FindingsSummaryGuidelineInfo(guideline.readableName(), guidelineRuleInfos, guidelineRuleCategories.values().stream().toList());
            if (guidelineInfo.getRuleInfos().isEmpty()) continue;
            guidelineInfos.add(guidelineInfo);
        }
        return guidelineInfos;
    }

    private Optional<FindingsSummaryGuidelineRuleInfo> calculateRuleSummary(Map<Set<ELanguage>, CounterSet<String>> numberOfEnabledChecksPerRule, CounterSet<String> numberOfAvailableChecksPerRule, RulesetInfo guidelineRule, Map<String, FindingsSummaryGuidelineRuleCategoryInfo> guidelineRuleCategories, Guideline guideline) {
        CounterSet<ETrafficLightColor> counter = this.rulesCounter.getOrDefault(guidelineRule, (CounterSet<ETrafficLightColor>)new CounterSet());
        int count = counter.getTotal();
        if (!this.reportRulesWithoutFindings && count == 0) {
            return Optional.empty();
        }
        int countRed = counter.getValue((Object)ETrafficLightColor.RED);
        int numberOfEnabledChecks = 0;
        for (Set<ELanguage> codeScopeLanguages : numberOfEnabledChecksPerRule.keySet()) {
            HashSet languages = CollectionUtils.intersectionSet(codeScopeLanguages, (Collection[])new Collection[]{guideline.supportedLanguages()});
            if (languages.isEmpty()) continue;
            numberOfEnabledChecks += numberOfEnabledChecksPerRule.get(codeScopeLanguages).getValue((Object)guidelineRule.ruleId);
        }
        int numberOfAvailableChecks = numberOfAvailableChecksPerRule.getValue((Object)guidelineRule.ruleId);
        String category = guidelineRule.ruleCategory;
        if (!StringUtils.isEmpty((String)category)) {
            FindingsSummaryGuidelineRuleCategoryInfo categoryInfo = guidelineRuleCategories.get(category);
            categoryInfo = categoryInfo == null ? new FindingsSummaryGuidelineRuleCategoryInfo(category, count, countRed, numberOfEnabledChecks, numberOfAvailableChecks) : new FindingsSummaryGuidelineRuleCategoryInfo(category, count + categoryInfo.getCount(), countRed + categoryInfo.getCountRed(), numberOfEnabledChecks + categoryInfo.getNumberOfEnabledChecks(), numberOfAvailableChecks + categoryInfo.getNumberOfAvailableChecks());
            guidelineRuleCategories.put(category, categoryInfo);
        }
        String ruleName = guidelineRule.getFullDescription();
        return Optional.of(new FindingsSummaryGuidelineRuleInfo(ruleName, count, countRed, numberOfEnabledChecks, numberOfAvailableChecks));
    }

    private static CounterSet<String> calculateNumberOfEnabledChecksPerGuidelineRule(Set<ELanguage> languages, FindingsSchema findingsSchema) {
        ListMap rulesByCheckId = GuidelineMapping.getInstance().getRulesByCheckId(languages);
        List<String> checkIds = findingsSchema.getEnabledFindingTypeIds().stream().map(typeId -> (String)StringUtils.splitAtFirst((String)typeId, (String)"/").getSecond()).toList();
        CounterSet numberOfChecksPerRule = new CounterSet();
        for (String checkId : checkIds) {
            Set ruleIds = ((List)rulesByCheckId.getCollectionOrEmpty((Object)checkId)).stream().map(rulesetInfo -> rulesetInfo.ruleId).collect(Collectors.toSet());
            numberOfChecksPerRule.incAll(ruleIds);
        }
        return numberOfChecksPerRule;
    }

    private CounterSet<String> calculateNumberOfAvailableChecksPerGuidelineRule() throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.calculationInfo.projectId(), (IndexLayer)this.calculationInfo.indexLayer());
        Set<ELanguage> languages = this.getLanguagesForAllProfiles(projectConfiguration);
        ListMap rulesByCheckId = GuidelineMapping.getInstance().getRulesByCheckId(languages);
        CounterSet numberOfChecksPerRule = new CounterSet();
        List<String> checks = this.getAvailableCheckIds(projectConfiguration);
        for (String checkId : checks) {
            Set ruleIds = ((List)rulesByCheckId.getCollectionOrEmpty((Object)checkId)).stream().map(rulesetInfo -> rulesetInfo.ruleId).collect(Collectors.toSet());
            numberOfChecksPerRule.incAll(ruleIds);
        }
        return numberOfChecksPerRule;
    }

    private List<String> getAvailableCheckIds(ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException {
        Set<ELanguage> languages = this.getLanguagesForAllProfiles(projectConfiguration);
        ArrayList<String> availableCheckIds = new ArrayList<String>();
        Set tools = EAnalysisTool.getAllToolsFor(languages).stream().filter(EAnalysisTool::isInternal).collect(Collectors.toSet());
        ConfigurationTemplate configurationTemplate = ConfigRegistry.getInstance().createConfigurationTemplate(languages, tools, this.calculationInfo.indexLayer().openGlobalStorageSystem());
        configurationTemplate.getAnalysisGroups().forEach(analysisGroup -> analysisGroup.getConfigurationItems().stream().filter(item -> item instanceof FindingDescriptor).forEach(findingDescriptor -> availableCheckIds.add(findingDescriptor.getName())));
        return availableCheckIds;
    }
}

