/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cppcheck;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CppcheckOutputParser {
    private static final Pattern FINDING_LINE_PATTERN = Pattern.compile("^(.*):(\\d+):(\\d+):\\s*(error|warning|information|style|performance|portability|unusedFunction|missingInclude):(.*)\\s*\\[(.*)\\]$");

    public static Optional<CppcheckResultItem> parseIssue(String line) {
        Matcher m = FINDING_LINE_PATTERN.matcher(line);
        if (m.matches()) {
            String checkId = m.group(6);
            if (checkId.equals("unmatchedSuppression")) {
                return Optional.empty();
            }
            String sourceFile = m.group(1);
            int lineNumber = Integer.parseInt(m.group(2));
            int lineColumn = Integer.parseInt(m.group(3));
            String message = m.group(5);
            return Optional.of(new CppcheckResultItem(sourceFile, lineNumber, lineColumn, message.strip(), checkId));
        }
        return Optional.empty();
    }

    public record CppcheckResultItem(String sourceFile, int lineNumber, int lineColumn, String message, String checkId) {
    }
}

