/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.powershellscriptanalyzer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class PowerShellScriptAnalyzerRunner {
    public static final String POWERSHELL_EXE_PROPERTY_NAME = "com.teamscale.powershell-exe";
    private static final String POWERSHELLSCRIPTANALYZER_MAX_PARALLEL_PROCESSES_VM_OPTION = "com.teamscale.powershell-analyzer.max-num-parallel-processes";
    private static final String POWERSHELLSCRIPTANALYZER_MAX_PARALLEL_PROCESSES_DEFAULT = "5";
    private static final String POWERSHELLSCRIPTANALYZER_PROCESS_TIMEOUT_VM_OPTION = "com.teamscale.powershell-analyzer.process_timeout_minutes";
    private static final String POWERSHELLSCRIPTANALYZER_PROCESS_TIMEOUT_DEFAULT = "7";
    private static final ExecutorService POWERSHELL_ANALYZER_JOB_EXECUTOR = WrappedExecutorServiceProducer.newFixedThreadPool((int)Integer.parseInt(System.getProperty("com.teamscale.powershell-analyzer.max-num-parallel-processes", "5")));
    public static final String POWERSHELL_EXECUTABLE_DEFAULT_NAME = "pwsh";
    private static final Pattern ANSI_CONTROL_ESCAPE_SEQUENCE_PATTERN = Pattern.compile("\\u001b\\[\\d{1,2}(;\\d{1,2})*m");
    private static final String SETTINGS_FILE_NAME = "PSScriptAnalyzerSettings.psd1";
    private final CodeScopeAware<ImmutableMap<String, String>> checkOptions;
    protected static final Logger LOGGER = LogManager.getLogger();
    public final TokenElementIndexCache tokenElementCache;
    protected final CommitDescriptor commit;

    public PowerShellScriptAnalyzerRunner(TokenElementIndexCache tokenElementCache, CommitDescriptor commit, CodeScopeAware<Map<String, String>> checkOptions) {
        this.tokenElementCache = tokenElementCache;
        this.commit = commit;
        this.checkOptions = checkOptions.map(ImmutableMap::copyOf);
    }

    private static void executeJobsInParallel(List<Callable<Void>> jobs, ExecutorService jobExecutor, String runnerName) {
        try {
            List<Future<Void>> futures = jobExecutor.invokeAll(jobs);
            if (futures.stream().anyMatch(future -> !future.isDone())) {
                LOGGER.error("Some " + runnerName + " job was not completed (future was not done). ExecutorService.invokeAll violated it's contract.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while running " + runnerName + ". Results might be incomplete.", (Throwable)e);
        }
    }

    public ListMap<String, IndexFinding> prepareAndRunPowerShellScriptAnalyzer(List<TokenElementInfo> filesToAnalyze, File jobTempDirectory, CodeScopeAware<List<String>> enabledChecks, boolean dryRun) throws IOException, StorageException {
        ListMap findings = new ListMap();
        CodeScopeAware<List<TokenElementInfo>> analyzedFilesByCodeScope = CodeScopeUtils.groupElementsByCodeScope(filesToAnalyze);
        for (CodeScopeName codeScopeName : analyzedFilesByCodeScope.getCodeScopeNames()) {
            List filesInCodeScope = (List)analyzedFilesByCodeScope.getValue(codeScopeName);
            File configFile = PowerShellScriptAnalyzerRunner.writeConfigFile(jobTempDirectory, (List)enabledChecks.getValue(codeScopeName), (ImmutableMap<String, String>)((ImmutableMap)this.checkOptions.getValue(codeScopeName)));
            if (dryRun) {
                for (int i = 0; i < filesInCodeScope.size(); ++i) {
                    TokenElementInfo element = (TokenElementInfo)((Object)filesInCodeScope.get(i));
                    this.runForElement(element, configFile, true, (ListMap<String, IndexFinding>)new ListMap(), i, jobTempDirectory);
                }
                return ListMap.emptyMap();
            }
            ArrayList<Callable<Void>> jobs = new ArrayList<Callable<Void>>();
            int i = 0;
            while (i < filesInCodeScope.size()) {
                int finalI = i++;
                jobs.add(() -> this.runForElement((TokenElementInfo)((Object)((Object)filesInCodeScope.get(finalI))), configFile, false, (ListMap<String, IndexFinding>)findings, finalI, jobTempDirectory));
            }
            PowerShellScriptAnalyzerRunner.executeJobsInParallel(jobs, POWERSHELL_ANALYZER_JOB_EXECUTOR, "powershellscriptanalyzer");
        }
        return findings;
    }

    private static File writeConfigFile(File tempDirectory, List<String> enabledChecks, ImmutableMap<String, String> checkOptions) throws IOException {
        File configFile = new File(tempDirectory, SETTINGS_FILE_NAME);
        String configFileContent = PowerShellScriptAnalyzerRunner.generateConfigFileContent(enabledChecks, checkOptions);
        FileSystemUtils.writeFile((File)configFile, (String)configFileContent, (Charset)StandardCharsets.UTF_8);
        return configFile;
    }

    @VisibleForTesting
    static @NonNull String generateConfigFileContent(List<String> enabledChecks, ImmutableMap<String, String> checkOptions) {
        String configFileContent = "@{\n\tIncludeRules=@(\n\t\t" + enabledChecks.stream().map(check -> "'" + check + "'").collect(Collectors.joining(",\n\t\t"));
        configFileContent = configFileContent + "\n\t)";
        if (!checkOptions.isEmpty()) {
            StringBuilder options = new StringBuilder("\n\tRules = @{");
            for (Map.Entry<String, SortedMap<String, String>> optionsForCheck : PowerShellScriptAnalyzerRunner.unravelCheckOptions(checkOptions).entrySet()) {
                String checkName = optionsForCheck.getKey();
                options.append("\n\t\t").append(checkName).append(" = @{\n\t\t\tEnable = $true");
                for (Map.Entry<String, String> optionNameAndValue : optionsForCheck.getValue().entrySet()) {
                    String optionName = optionNameAndValue.getKey();
                    String optionValue = optionNameAndValue.getValue();
                    options.append("\n\t\t\t").append(optionName).append(" = ").append(optionValue);
                }
                options.append("\n\t\t}");
            }
            options.append("\n\t}");
            configFileContent = configFileContent + String.valueOf(options);
        }
        configFileContent = configFileContent + "\n}";
        return configFileContent;
    }

    private static SortedMap<String, SortedMap<String, String>> unravelCheckOptions(ImmutableMap<String, String> checkOptions) {
        TreeMap<String, SortedMap<String, String>> options = new TreeMap<String, SortedMap<String, String>>();
        for (Map.Entry option : checkOptions.entrySet()) {
            int delimiterPosition = ((String)option.getKey()).indexOf(".");
            String checkName = ((String)option.getKey()).substring(0, delimiterPosition);
            String optionName = ((String)option.getKey()).substring(delimiterPosition + 1);
            String optionValue = PowerShellScriptAnalyzerRunner.convertOptionValueToPowerShell((String)option.getValue());
            SortedMap optionsForCurrentCheck = options.computeIfAbsent(checkName, key -> new TreeMap());
            optionsForCurrentCheck.put(optionName, optionValue);
        }
        return options;
    }

    private static String convertOptionValueToPowerShell(String value) {
        if ("true".equals(value)) {
            return "$true";
        }
        if ("false".equals(value)) {
            return "$false";
        }
        if (StringUtils.isInteger((String)value)) {
            return value;
        }
        return "'" + value + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void runForElement(TokenElementInfo element, File configFile, boolean dryRun, ListMap<String, IndexFinding> findings, int analyzedFileNumber, File jobDirectory) {
        File scriptFile;
        try {
            File checkDirectory = new File(jobDirectory, String.valueOf(analyzedFileNumber));
            scriptFile = PowerShellScriptAnalyzerRunner.writeScriptFile(element, checkDirectory);
        }
        catch (IOException e) {
            LOGGER.error("PowerShellScriptAnalyzerRunner could not write script file to " + String.valueOf(jobDirectory), (Throwable)e);
            return null;
        }
        try {
            ProcessWrapper process = PowerShellScriptAnalyzerRunner.generatePowerShellAnalyzerProcess(configFile, scriptFile);
            if (dryRun) {
                FileSystemUtils.writeFileUTF8((File)new File(scriptFile.getParent(), "PowerShellScriptAnalyzer_Command_" + analyzedFileNumber + ".txt"), (String)("This is the command we use to run PowerShellScriptAnalyzer:\n" + process.getCommand()));
                return null;
            }
            List<PowerShellScriptAnalyzerResultItem> resultItems = PowerShellScriptAnalyzerRunner.runPowerShellScriptAnalyzer(process, element.getUniformPath());
            List<IndexFinding> findingsOnElement = this.convertResultsToFindings(element, resultItems);
            ListMap<String, IndexFinding> listMap = findings;
            synchronized (listMap) {
                findings.addAll((Object)element.getUniformPath(), findingsOnElement);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while running PowerShellScriptAnalyzer for uniform path " + element.getUniformPath(), (Throwable)e);
        }
        return null;
    }

    private static File writeScriptFile(TokenElementInfo element, File checkDirectory) throws IOException {
        String filename = UniformPathUtils.getElementName((String)element.getUniformPath());
        File scriptFile = new File(checkDirectory, FileSystemUtils.toSafeFilename((String)FileSystemUtils.getFilenameWithoutExtension((String)filename)) + "." + FileSystemUtils.getFileExtension((String)filename));
        FileSystemUtils.writeFileUTF8((File)scriptFile, (String)element.getText());
        return scriptFile;
    }

    private static @NonNull ProcessWrapper generatePowerShellAnalyzerProcess(File configFile, File mainFile) {
        String powerShellExe = PowerShellScriptAnalyzerRunner.loadConfiguredPowerShellExe();
        ProcessWrapper process = new ProcessWrapper(powerShellExe);
        process.setWorkingDirectory(mainFile.getParentFile());
        process.addArgument("-NonInteractive");
        process.addArgument("-Command");
        process.addArgument("Set-Variable WarningPreference SilentlyContinue;Import-Module PSScriptAnalyzer;Invoke-ScriptAnalyzer -Path '%s' -Settings '../%s'\n\t| ConvertTo-Json -AsArray -EnumsAsStrings -depth 100\n".formatted(mainFile.getAbsolutePath(), configFile.getName()));
        return process;
    }

    private static List<PowerShellScriptAnalyzerResultItem> runPowerShellScriptAnalyzer(ProcessWrapper process, String uniformPath) {
        ArrayList<String> outputLines = new ArrayList<String>();
        ArrayList errorLines = new ArrayList();
        process.setOutputConsumer(line -> outputLines.add(PowerShellScriptAnalyzerRunner.removeAnsiEscapeSequences(line)));
        process.setErrorConsumer(line -> errorLines.add(PowerShellScriptAnalyzerRunner.removeAnsiEscapeSequences(line)));
        int timeoutMinutes = PowerShellScriptAnalyzerRunner.determinePowerShellProcessTimeoutMinutes();
        int returnCode = process.runWithTimeout(timeoutMinutes);
        if (returnCode != 0 && !errorLines.isEmpty()) {
            Level logLevel = Level.WARN;
            String error = String.join((CharSequence)"\n", errorLines);
            if (error.contains("/PSScriptAnalyzerSettings.psd1")) {
                logLevel = Level.ERROR;
            }
            LOGGER.log(logLevel, "Received errors from PowerShellScriptAnalyzer on uniform path {}:\n{}", (Object)uniformPath, (Object)error);
        }
        if (returnCode == 0) {
            return new ArrayList<PowerShellScriptAnalyzerResultItem>(PowerShellScriptAnalyzerRunner.parseResultLines(outputLines));
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    static List<PowerShellScriptAnalyzerResultItem> parseResultLines(List<String> outputLines) {
        if (outputLines.isEmpty()) {
            return Collections.emptyList();
        }
        String output = String.join((CharSequence)"\n", outputLines);
        try {
            List list = (List)JsonUtils.deserializeFromJson((String)output, (TypeReference)new TypeReference<List<Map<String, JsonNode>>>(){});
            ArrayList<PowerShellScriptAnalyzerResultItem> resultItems = new ArrayList<PowerShellScriptAnalyzerResultItem>();
            for (Map element : list) {
                String checkId = ((JsonNode)element.get("RuleName")).textValue();
                String severity = ((JsonNode)element.get("Severity")).textValue();
                int lineNumber = ((JsonNode)element.get("Line")).intValue();
                String message = ((JsonNode)element.get("Message")).textValue();
                resultItems.add(new PowerShellScriptAnalyzerResultItem(checkId, severity, lineNumber, message));
            }
            return resultItems;
        }
        catch (JsonSerializationException e) {
            LOGGER.error("Cannot parse output from PowerShellScriptAnalyzer", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static int determinePowerShellProcessTimeoutMinutes() {
        String optionValue = System.getProperty(POWERSHELLSCRIPTANALYZER_PROCESS_TIMEOUT_VM_OPTION, POWERSHELLSCRIPTANALYZER_PROCESS_TIMEOUT_DEFAULT);
        try {
            return Integer.parseInt(optionValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Could not parse the value of the VM option com.teamscale.powershell-analyzer.process_timeout_minutes as an integer. This must be a timeout (positive integer) in minutes. The value is `" + optionValue + "`.");
        }
    }

    private List<IndexFinding> convertResultsToFindings(TokenElementInfo element, List<PowerShellScriptAnalyzerResultItem> resultItems) {
        if (resultItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexFinding> findings = new ArrayList<IndexFinding>();
        String uniformPath = element.getUniformPath();
        LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(element.getText());
        for (PowerShellScriptAnalyzerResultItem resultItem : resultItems) {
            int line = resultItem.lineNumber;
            if (resultItem.severity.equals("ParseError")) {
                this.logErrorToParseLog(uniformPath, resultItem);
                continue;
            }
            TextRegionLocation location = new TextRegionLocation(uniformPath, lineOffsetConverter.getOffset(line), lineOffsetConverter.getOffset(line + 1) - 1, line, line);
            String message = MarkupUtils.escapeMarkdownRelevantSymbols((String)resultItem.message);
            message = StringUtils.truncateWithEllipsis((String)message, (int)1000);
            IndexFinding finding = new IndexFinding(resultItem.checkId, "PowerShellScriptAnalyzer", message, (ElementLocation)location);
            IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)resultItem.checkId, (Set)EAnalysisTool.POWERSHELL_SCRIPT_ANALYZER.getSupportedLanguages());
            findings.add(finding);
        }
        return findings;
    }

    private void logErrorToParseLog(String uniformPath, PowerShellScriptAnalyzerResultItem resultItem) {
        String message = resultItem.checkId + ": " + resultItem.message;
        LOGGER.info(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER, (Message)new ParseLogMessage(EParseLogOrigin.POWERSHELL_SCRIPT_ANALYZER.name(), message, uniformPath, resultItem.lineNumber));
    }

    static ProcessResult getNonAnalysisCommandLineOutput(String ... options) {
        String powerShellScriptAnalyzerExe = PowerShellScriptAnalyzerRunner.loadConfiguredPowerShellExe();
        ProcessWrapper process = new ProcessWrapper(powerShellScriptAnalyzerExe);
        for (String parameter : options) {
            process.addArgument(parameter);
        }
        StringBuffer stdOut = new StringBuffer();
        StringBuffer stdErr = new StringBuffer();
        process.setOutputConsumer(line -> stdOut.append((String)line).append("\n"));
        process.setErrorConsumer(line -> stdErr.append((String)line).append("\n"));
        process.writeExceptionsToErrorOutput = true;
        int returnCode = process.runWithTimeout(1);
        return new ProcessResult(returnCode, PowerShellScriptAnalyzerRunner.removeAnsiEscapeSequences(stdOut.toString()), stdErr.toString());
    }

    @VisibleForTesting
    static String removeAnsiEscapeSequences(String stringWithControlSequences) {
        return ANSI_CONTROL_ESCAPE_SEQUENCE_PATTERN.matcher(stringWithControlSequences).replaceAll("");
    }

    public static String loadConfiguredPowerShellExe() {
        return System.getProperty(POWERSHELL_EXE_PROPERTY_NAME, POWERSHELL_EXECUTABLE_DEFAULT_NAME);
    }

    public static class PowerShellScriptAnalyzerResultItem {
        public final String checkId;
        public final String severity;
        public final int lineNumber;
        public final String message;

        private PowerShellScriptAnalyzerResultItem(String checkId, String severity, int lineNumber, String message) {
            this.lineNumber = lineNumber;
            this.checkId = checkId;
            this.severity = severity;
            this.message = message;
        }
    }

    record ProcessResult(int returnCode, String stdOut, String stdErr) {
    }
}

