/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.client.RtcWorkItemClient;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import com.teamscale.wia.TeamscaleIssue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public abstract class RtcSynchronizerBase<T extends TeamscaleIssue>
extends IssueTrackerSynchronizerBase<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String FIELD_FILTER_PARAMETER = "field-filter";
    public static final String ITEM_TYPE_PARAMETER_NAME = "item-type";
    @StepParameter(value="field-filter")
    protected String additionalFieldFilter;
    protected static final String CLOSED_STATE_GROUP = "closed";
    protected RtcWorkItemClient client;

    @Override
    protected void init() throws BugTrackerException {
        this.setClient(new RtcWorkItemClient(this.getUrl(), this.getUsername(), this.getPassword()));
        this.determineStandardFieldTypeMappings();
    }

    protected void setClient(RtcWorkItemClient client) {
        this.client = client;
    }

    protected void determineStandardFieldTypeMappings() {
        this.addFieldTypeMapping("created", EKeyedObjectType.DATE);
        this.addFieldTypeMapping("updated", EKeyedObjectType.DATE);
    }

    protected List<T> retrieveIssueHistory(List<RtcWorkItem> workItems, long lastScanTimestamp, long startTimestamp, List<String> workItemLinks) throws StorageException {
        ArrayList<T> issues = new ArrayList<T>();
        Set<String> newIssues = this.filterToUnknownIssuesByExternalId(CollectionUtils.map(workItems, item -> Long.toString(item.getId())));
        for (RtcWorkItem workItem : workItems) {
            try {
                List<RtcWorkItem> history = this.client.fetchWorkItemHistory(workItem.getId(), (PairList<String, Boolean>)this.customFields, workItemLinks);
                if (history == null) {
                    LOGGER.error("No history returned for work item {}. Continuing with other items.", (Object)workItem.getIdAsString());
                    issues.add(this.createIssue(workItem, this.connectorId));
                    continue;
                }
                this.processAndAddWorkItemHistory(workItem, history, newIssues, lastScanTimestamp, startTimestamp, issues);
            }
            catch (ServiceCallException e) {
                LOGGER.error("Failed to fetch history of work item {}. Continuing with other items.", (Object)workItem.getId(), (Object)e);
            }
        }
        return issues;
    }

    private void processAndAddWorkItemHistory(RtcWorkItem workItem, List<RtcWorkItem> history, Set<String> newIssues, long lastScanTimestamp, long startTimestamp, List<T> issues) {
        long boundaryTimestamp;
        Optional<Object> startItem = Optional.empty();
        if (newIssues.contains(Long.toString(workItem.getId()))) {
            boundaryTimestamp = startTimestamp;
            startItem = history.stream().filter(item -> item.getModificationTimestamp() < boundaryTimestamp).max(Comparator.comparingLong(RtcWorkItem::getModificationTimestamp));
        } else {
            boundaryTimestamp = lastScanTimestamp;
        }
        issues.addAll(CollectionUtils.filterAndMap(history, item -> item.getModificationTimestamp() >= boundaryTimestamp, issue -> {
            if (issue.getModificationTimestamp() == workItem.getModificationTimestamp()) {
                return this.createIssue(workItem, this.connectorId);
            }
            return this.createIssue((RtcWorkItem)issue, this.connectorId);
        }));
        startItem.ifPresent(item -> issues.add(this.createIssue((RtcWorkItem)item, this.connectorId, startTimestamp)));
    }

    private T createIssue(RtcWorkItem workItem, String connectorId) {
        return this.createIssue(workItem, connectorId, 0L);
    }

    protected abstract T createIssue(RtcWorkItem var1, String var2, long var3);

    protected abstract Set<String> getItemTypes();
}

