/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.tfs.TfsWorkItem;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.tfs.TfsWorkItemSynchronizerBase;
import com.teamscale.wia.TeamscaleIssue;
import java.util.HashSet;
import java.util.Set;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class TfsWorkItemSynchronizer
extends TfsWorkItemSynchronizerBase<TeamscaleIssue> {
    public static final String INCLUDE_LINKS_PARAMETER = "include-links";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueHistoryIndex issueHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueIndex issueIndex;
    @StepParameter(value="item-type", optional=true)
    private final Set<String> itemTypes = new HashSet<String>();
    @StepParameter(value="include-links", optional=true)
    private boolean fetchParentLinks = false;

    @Override
    protected TeamscaleIssue createIssue(TeamscaleIssue preParsedIssue, TfsWorkItem tfsWorkItem, String type) {
        return preParsedIssue;
    }

    @Override
    protected long determineBoundaryTimestamp(long lastScanTimestamp, long startTimestamp, boolean isNew) {
        if (isNew) {
            return startTimestamp;
        }
        return lastScanTimestamp + 1L;
    }

    @Override
    protected boolean shouldFetchRelations() {
        return this.fetchParentLinks;
    }

    public IssueHistoryIndex getIssueHistoryIndex() {
        return this.issueHistoryIndex;
    }

    @Override
    protected IssueIndexBase<TeamscaleIssue> getWorkItemIndex() {
        return this.issueIndex;
    }

    @Override
    protected Set<String> getItemTypes() {
        return this.itemTypes;
    }
}

