/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import java.util.ArrayList;
import java.util.List;

public class MigrateVersion185CppcheckUseCheckID {
    public static List<ConfigurationOptionMigrationBase> getMigrations() {
        ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>();
        migrations.add(new ConfigurationOptionReplacement("This configuration was not checked because ist code equals another one", "purgedConfiguration", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Too many configurations", "toomanyconfigs", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Assignment of address to integer", "AssignmentAddressToInteger", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Assignment of integer to address", "AssignmentIntegerToAddress", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Cast of integer to address at return", "CastIntegerToAddressAtReturn", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Cast of address to integer at return", "CastAddressToIntegerAtReturn", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Warn if there are side effects in assert statements (since this cause different behaviour in debug/release builds).", "assertWithSideEffect", "Assertions"));
        migrations.add(new ConfigurationOptionReplacement("Assignment in 'assert'", "assignmentInAssert", "Assertions"));
        migrations.add(new ConfigurationOptionReplacement("Address of local auto-variable assigned to a function parameter", "autoVariables", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Reference to local variable returned", "returnReference", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Non-local reference variable to local variable", "danglingReference", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Reference to temporary returned", "returnTempReference", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using reference to dangling temporary", "danglingTempReference", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Deallocation results in undefined behaviour", "autovarInvalidDeallocation", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Assignment of function parameter has no effect outside the function", "uselessAssignmentArg", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Assignment Pointer of function parameter has no effect outside the function", "uselessAssignmentPtrArg", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Lifetime will be invalid when returning", "returnDanglingLifetime", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Lifetime is out of scope", "invalidLifetime", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Dangling lifetime", "danglingLifetime", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Dangling temporary lifetime", "danglingTemporaryLifetime", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Assigning bool value to pointer", "assignBoolToPointer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Assigning bool value to float", "assignBoolToFloat", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparing booleans using relational operators (bool value and bool function)", "comparisonOfFuncReturningBoolError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparing booleans using relational operators (two bool functions)", "comparisonOfTwoFuncsReturningBoolError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparing booleans using relational operators (two bool values)", "comparisonOfBoolWithBoolError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Using increment on boolean", "incrementboolean", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using bool in bitwise expression", "bitwiseOnBoolean", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparison of a boolean expression with an integer other than 0 or 1", "compareBoolExpressionWithInt", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Converting pointer arithmetic result to bool", "pointerArithBool", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Comparison of a boolean value using relational operator", "comparisonOfBoolWithInvalidComparator", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Returning an integer other than 0 or 1 from a function with boolean return value", "returnNonBoolInBooleanFunction", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("BOOST_FOREACH error", "boostForeachError", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Array index out of bounds", "arrayIndexOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Array index out of bounds (condition)", "arrayIndexOutOfBoundsCond", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Pointer arithmetic overflow", "pointerOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Pointer arithmetic overflow (condition)", "pointerOutOfBoundsCond", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Negative index", "negativeIndex", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using array index before checking it", "arrayIndexThenCheck", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Buffer overflow", "bufferAccessOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The address of a local variable is accessed at non-zero index", "objectIndex", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Buffer is too small", "argumentSize", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Memory allocation size is negative", "negativeMemoryAllocationSize", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Declaration of array with negative size is undefined behaviour", "negativeArraySize", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Invalid input values for functions", "invalidFunctionArg", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Invalid input values for functions (boolean)", "invalidFunctionArgBool", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Invalid input values for functions (String)", "invalidFunctionArgStr", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Return value of certain functions is ignored", "ignoredReturnValue", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Passing value leads to undefined result", "wrongmathcall", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Expression can be replaced to avoid loss of precision", "unpreciseMathCall", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("memset() called to fill 0 bytes", "memsetZeroBytes", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The 2nd memset() argument is a float", "memsetFloat", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The 2nd memset() argument doesn't fit into an 'unsigned char'", "memsetValueOutOfRange", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Missing 'return' in non-void function", "missingReturn", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using std::move for returning object by-value from function", "returnStdMoveLocal", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Consider using memcpy instead of loop", "useStandardLibrary", "Modernization"));
        migrations.add(new ConfigurationOptionReplacement("Missing constructors", "noConstructor", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Constructors which should be explicit", "noExplicitConstructor", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Value of pointer is copied instead of allocating new memory", "copyCtorPointerCopying", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Missing copy constructors", "noCopyConstructor", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Missing equals operator", "noOperatorEq", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Class with memory management should have destructor", "noDestructor", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is not initialized", "uninitMemberVar", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Private member variable is not initialized", "uninitMemberVarPrivate", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Uninitialized member variable", "uninitDerivedMemberVar", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Uninitialized private member variable", "uninitDerivedMemberVarPrivate", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is not assigned in the constructor", "missingMemberCopy", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is not assigned a value in operator", "operatorEqVarError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused private functions", "unusedPrivateFunction", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Using memory function on this type is unsafe", "memsetClass", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Using memory function on a type that contains a reference", "memsetClassReference", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Using memset() on a type which contains a floating point number", "memsetClassFloat", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Memory for class instance not allocated by constructor", "mallocOnClassWarning", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Memory for class instance allocated with memory function", "mallocOnClassError", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Base class does not have a virtual destructor", "virtualDestructor", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Suspicious subtraction from 'this'", "thisSubtraction", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Equals operator should return reference to 'this' instance", "operatorEqRetRefThis", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("No 'return' statement in non-void function causes undefined behavior", "operatorEqMissingReturnStatement", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Equals operator should either return reference to 'this' instance or be declared private and left unimplemented", "operatorEqShouldBeLeftUnimplemented", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Equals operator should check for assignment to self to avoid problems with dynamic memory", "operatorEqToSelf", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Check if this const function should be const", "functionConst", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Check if this static function should be static", "functionStatic", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is in the wrong place in the initializer list", "initializerList", "Member Ordering"));
        migrations.add(new ConfigurationOptionReplacement("Use initialization list", "useInitializationList", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is initialized by itself", "selfInitialization", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Member variable is also defined in the parent class/struct", "duplInheritedMember", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Struct/class has only copy constructor or equal operator", "copyCtorAndEqOperator", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The function overrides a function in a base class but just delegates back to the base class", "uselessOverride", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("The function should return the member by constant reference", "returnByReference", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Call of pure virtual function", "pureVirtualCall", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Vitual function is called from constrcutor", "virtualCallInConstructor", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Check that the 'override' keyword is used when overriding virtual functions", "missingOverride", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Calling methof when 'this' might be invalid", "thisUseAfterFree", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Unsafe class: The const reference member is initialized by a const reference constructor argument", "unsafeClassRefMember", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Mismatching assignment and comparison", "assignIfError", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Result of operator '|' is always true if one operand is non-zero", "badBitmaskCheck", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Result is always true/false", "comparisonError", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The if condition is the same as the previous if condition", "duplicateCondition", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Else if condition is always true/false", "multiCondition", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Mismatching bitmasks, result is always 0", "mismatchingBitAnd", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Opposite inner condition", "oppositeInnerCondition", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Identical inner condition", "identicalInnerCondition", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Identical condition after early exit", "identicalConditionAfterEarlyExit", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Incorrect logical operator", "incorrectLogicOperator", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Redundant condition", "redundantCondition", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Result of this modulo operation is always true/false", "moduloAlwaysTrueFalse", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Suspicious condition (assignment+comparison)", "clarifyCondition", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Condition is always true/false", "knownConditionTrueFalse", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Overflow check may be removed by compiler optimization", "invalidTestForOverflow", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Wrong comparison, possible pointer overflow", "pointerAdditionResultNotNull", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Assignment/condition is redundant", "duplicateConditionalAssign", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Suspicious assignment in condition, condition is always true", "assignmentInCondition", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparing expression against value, condition is always true/false", "compareValueOutOfTypeRangeError", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Class is not safe, destructor throws exception", "exceptThrowInDestructor", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Exception thrown in invalid state (deallocated memory)", "exceptDeallocThrow", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Throwing a copy of the caught exception", "exceptRethrowCopy", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Exception is caught by value, should be caught by reference", "catchExceptionByValue", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Exception thrown in function declared not to throw exceptions", "throwInNoexceptFunction", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Unhandled exception specification when calling function", "unhandledExceptionSpecification", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("\"Rethrowing current exception with 'throw;'\"", "rethrowNoCurrentException", "Exception Design"));
        migrations.add(new ConfigurationOptionReplacement("Invalid usage of output stream", "coutCerrMisusage", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("fflush() called on input stream", "fflushOnInputStream", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Read and write operations without a call to a positioning function (fseek, fsetpos or rewind) or fflush", "IOWithoutPositioning", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Read operation on a file that was opened only for writing", "readWriteOnlyFile", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Write operation on a file that was opened only for reading", "writeReadOnlyFile", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Used file that is not opened", "useClosedFile", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Repositioning operation performed on a file opened in append mode", "seekOnAppendedFile", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("File is opened for read and write access at the same time on different streams", "incompatibleFileOpen", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("scanf without field width limits can crash with huge input data", "invalidscanf", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument number in printf/scanf", "wrongPrintfScanfArgNum", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in scanf, char/wchar_t is required", "invalidScanfArgType_s", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in scanf, int is required", "invalidScanfArgType_int", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in scanf, float is required", "invalidScanfArgType_float", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, char * is required", "invalidPrintfArgType_s", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, int * is required", "invalidPrintfArgType_n", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, address is required", "invalidPrintfArgType_p", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, unint is required", "invalidPrintfArgType_uint", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, sint is required", "invalidPrintfArgType_sint", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong argument type in printf, float is required", "invalidPrintfArgType_float", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("A length modifier cannot be used without a conversion specifier.", "invalidLengthModifierError", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Given width in format string is larger than destination buffer", "invalidScanfFormatWidth", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Given width in format string is smaller than destination buffer", "invalidScanfFormatWidth_smaller", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Wrong printf/scanf parameter position error", "wrongPrintfScanfParameterPositionError", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Returning/dereferencing after deallocation / release", "deallocret", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Resource is freed twice", "doubleFree", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Allocation does not release it", "leakNoVarFunctionCall", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Return value of allocation function is not stored", "leakReturnValNotUsed", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Unsafe allocation", "leakUnsafeArgAlloc", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Possible leak in public functin", "publicAllocationError", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Class is unsafe, member can leak by wrong usage", "unsafeClassCanLeak", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Memory leak", "memleak", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Resource leak", "resourceLeak", "Resource Leaks"));
        migrations.add(new ConfigurationOptionReplacement("Dereferencing deallocation / release", "deallocuse", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Mismatching allocation and deallocation", "mismatchAllocDealloc", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Variable nulled but not freed upon failure", "memleakOnRealloc", "Memory Leaks"));
        migrations.add(new ConfigurationOptionReplacement("C/C++ Null pointer dereference", "nullPointer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Possible null pointer dereference if the default parameter value is used", "nullPointerDefaultArg", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Possible null pointer derefernce or redundant condition", "nullPointerRedundantCheck", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Overflow in pointer arithmetic", "nullPointerArithmetic", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("There is a pointer arithmetic with NULL pointer or a redundant condition", "nullPointerArithmeticRedundantCheck", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Division by zero", "zerodiv", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The condition is redundant or there is a division by zero", "zerodivcond", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Unused scoped object", "unusedScopedObject", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Invalid pointer cast", "invalidPointerCast", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Shifting a negative value", "shiftNegativeLHS", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Shifting by a negative value", "shiftNegative", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Race condition: non-interlocked access after InterlockedDecrement", "raceAfterInterlockedDecrement", "Concurrency"));
        migrations.add(new ConfigurationOptionReplacement("Mismatching address is deleted/freed", "invalidFree", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Overlapping read/write of union", "overlappingWriteUnion", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Overlapping read/write in function", "overlappingWriteFunction", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Unnecessary data copying", "redundantCopyLocalConst", "Memory Performance"));
        migrations.add(new ConfigurationOptionReplacement("Buffer is being written before its old content has been used", "redundantCopy", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Comparison of two identical variables", "comparisonFunctionIsAlwaysTrueOrFalse", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Storing return value in char variable and then comparing with EOF", "checkCastIntToCharAndBack", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("C-style pointer casting", "cstyleCast", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Floating-point cast causes loss of precision", "suspiciousFloatingPointCast", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Function parameter should be passed by reference", "passedByValue", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Parameter can be declared with const", "constParameter", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Variable can be declared with const", "constVariable", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Parameter can be declared with const (Parameter reference)", "constParameterReference", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Variable can be declared with const (Reference)", "constVariableReference", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Parameter can be declared with const (Parameter pointer)", "constParameterPointer", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Variable can be declared with const (Pointer)", "constVariablePointer", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Parameter 'x' can be declared with const, however it seems that 'f' is a callback function", "constParameterCallback", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("Redundant code:  statement that begins with constant", "constStatement", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Signed 'char' type used as array index", "signedCharArrayIndex", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("'char' type used as array index", "unknownSignCharArrayIndex", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Char variable in bit operations", "charBitOp", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The scope of the variable can be reduced", "variableScope", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Redundant assignment in switch", "redundantAssignInSwitch", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Suspicious case label in switch", "suspiciousCase", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Variable is assigned to itself", "selfAssignment", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Clarify calculation with parentheses", "clarifyCalculation", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused result of expression like '*A++'", "clarifyStatement", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Identical code in both branches", "duplicateBranch", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same expression is used in consecutive assignments", "duplicateAssignExpression", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Opposite expression", "oppositeExpression", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Duplicate expression", "duplicateExpression", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same value in both branches of ternary operator", "duplicateValueTernary", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same expression in both branches of ternary operator", "duplicateExpressionTernary", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Duplicate break statement", "duplicateBreak", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unreachable code", "unreachableCode", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unsigned value is less than zero", "unsignedLessThanZero", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Check if unsigned variable is always positive", "unsignedPositive", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Pointer is less than zero", "pointerLessThanZero", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Pointer is not positive", "pointerPositive", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Suspicious semicolon at the end of 'if/for/while' statement.", "suspiciousSemicolon", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Array is/might be filled incompletely", "incompleteArrayFill", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Passing NULL after the last typed argument to a variadic function", "varFuncNullUB", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Nan in an arithmetic expression", "nanInArithmeticExpression", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Comma in return statement (the comma can easily be misread as a semicolon)", "commaSeparatedReturn", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Redundant pointer operation", "redundantPointerOp", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused label in #if or switch", "unusedLabel", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused label configuration", "unusedLabelConfiguration", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused label in switch", "unusedLabelSwitch", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unused label configuration in switch", "unusedLabelSwitchConfiguration", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Expression depends on order of evaluation of side effects", "unknownEvaluationOrder", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Access of moved variable", "accessMoved", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Access of forwarded variable", "accessForwarded", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Different function argument names", "funcArgNamesDifferent", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("Redundant bitwise operation in switch statement", "redundantBitwiseOperationInSwitch", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Shadowed variable", "shadowVariable", "Name Shadowing"));
        migrations.add(new ConfigurationOptionReplacement("Shadowed function", "shadowFunction", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Shadowed argument", "shadowArgument", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Argument 'x-x' is always 0", "knownArgument", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Argument 'x*0' is always 0", "knownArgumentHiddenVariableExpression", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Pointer expression 'p' converted to bool is always true", "knownPointerToBool", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Comparing/subtracting pointers that point to different objects", "comparePointers", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Variable is reassigned a value before the old one has been used", "redundantAssignment", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Redundant initialization", "redundantInitialization", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Function argument order different", "funcArgOrderDifferent", "Member Ordering"));
        migrations.add(new ConfigurationOptionReplacement("Modulo of 1", "moduloofone", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("OutOfBounds exception", "containerOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Invalid iterator", "invalidIterator1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same iterator is used with different containers (1)", "iterators1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same iterator is used with different containers (2)", "iterators2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same iterator is used with containers that are temporaries or defined in different scopes", "iterators3", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Calling method while iterating the container is invalid", "invalidContainerLoop", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using container that may be invalid", "invalidContainer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Iterator from different container are used together", "mismatchingContainerIterator", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Iterators to containers from different expressions are used together", "mismatchingContainers", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Iterators of different containers and are used together", "mismatchingContainerExpression", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Same iterators expression are used for algorithm", "sameIteratorExpression", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Iterator used after element has been erased", "eraseDereference", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Out of bounds error", "stlOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Negative array index", "negativeContainerIndex", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Dangerous comparison using operator < on iterator", "stlBoundaries", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: The result of find() is an iterator, but it is not properly checked", "stlIfFind", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Inefficient usage of string::find()", "stlIfStrFind", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Searching before insertion is not necessary", "stlFindInsert", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: The value returned by c_str() is invalid after this call", "stlcstr", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Returning the result of c_str() in a function that returns std::string is slow and redundant", "stlcstrReturn", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Passing the result of c_str() to a function that takes std::string as argument is slow and redundant", "stlcstrParam", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: The value returned by c_str() is invalid after throwing exception", "stlcstrthrow", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: Checking for emptiness might be inefficient", "stlSize", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Standard Template Library: There is no comparison between these increments to prevent that the iterator is incremented beyond the end", "StlMissingComparison", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Redundant checking of STL container element existence before removing it", "redundantIfRemove", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("It is inefficient to call 'compare'", "uselessCallsCompare", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("It is inefficient to call 'swap'", "uselessCallsSwap", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("Ineffective call of function 'substr'", "uselessCallsSubstr", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Ineffective call of function 'empty'", "uselessCallsEmpty", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Return value of 'remove' is ignored", "uselessCallsRemove", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Dereference of an invalid iterator", "derefInvalidIterator", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Calling function 'erase()' on the iterator 'iter' which is out of bounds", "eraseIteratorOutOfBounds", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Either the condition 'x' is redundant or function 'erase()' is called on the iterator 'iter' which is out of bounds", "eraseIteratorOutOfBoundsCond", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Consider using STL algorithm instead of a raw loop", "useStlAlgorithm", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Iterating over container that is always empty", "knownEmptyContainer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Lock guard is defined globally", "globalLockGuard", "Concurrency"));
        migrations.add(new ConfigurationOptionReplacement("Ineffective mutex", "localMutex", "Concurrency"));
        migrations.add(new ConfigurationOptionReplacement("Using sizeof for array given as function argument", "sizeofwithsilentarraypointer", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Using sizeof(pointer) instead of the size of pointed data", "pointerSize", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Division by result of sizeof() and memory function expects a size in bytes", "sizeofDivisionMemfunc", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Using sizeof with a numeric constant", "sizeofwithnumericparameter", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Look for 'sizeof sizeof ..'", "sizeofsizeof", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Look for calculations inside sizeof()", "sizeofCalculation", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Look for function calls inside sizeof()", "sizeofFunctionCall", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Look for suspicious multiplications with sizeof()", "multiplySizeof", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Look for suspicious divisions with sizeof()", "divideSizeof", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Using 'sizeof(void)' which is undefined", "sizeofVoid", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using 'sizeof' with dereferenced void pointer which is undefined", "sizeofDereferencedVoidPointer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using void pointers in calculations which is undefinded", "arithOperationsOnVoidPointer", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Undefined modification of string literal", "stringLiteralWrite", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Using variable both as a parameter and as destination in a function call", "sprintfOverlappingData", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Char type is added to a string literal", "strPlusChar", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Incorrect string compare: String literal doesn't match length argument", "incorrectStringCompare", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("String literal compared with variable without compare function", "literalWithCharPtrCompare", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Char literal compared with pointer without dereferencing", "charLiteralWithCharPtrCompare", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Conversion of string literal to bool always evaluates to the same value", "incorrectStringBooleanError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Conversion of char literal to bool always evaluates to the same value", "incorrectCharBooleanError", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Unnecessary comparison of static strings", "staticStringCompare", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Comparison of identical string variables", "stringCompare", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Overlapping strcmp expressions", "overlappingStrcmp", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Bitwise shift by too many bits", "shiftTooManyBits", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Signed bitwise shift by too many bits", "shiftTooManyBitsSigned", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Integer overflow", "integerOverflow", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Dangerous sign conversion, when signed value can be negative", "signConversion", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("int result is assigned to long variable", "truncLongCastAssignment", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("int result is returned as long value", "truncLongCastReturn", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Float conversion overflow", "floatConversionOverflow", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using uninitialized data", "uninitdata", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Using an uninitialized struct member", "uninitStructMember", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Unused function", "unusedFunction", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unused variable", "unusedVariable", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unused allocated memory", "unusedAllocatedMemory", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unread variable", "unreadVariable", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unassigned variable", "unassignedVariable", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Unused struct member", "unusedStructMember", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("Warn if using postfix operators ++ or -- rather than prefix operator", "postfixOperator", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Wrong parameter passed to va_start() (variable argument lists)", "va_start_wrongParameter", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Reference passed to va_start() (variable argument lists)", "va_start_referencePassed", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Missing va_end() (variable argument lists)", "va_end_missing", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Using va_list before it is opened (variable argument lists)", "va_list_usedBeforeStarted", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Subsequent calls to va_start/va_copy() (variable argument lists)", "va_start_subsequentCalls", "API Misuse"));
        migrations.add(new ConfigurationOptionReplacement("Preprocessor error directive", "preprocessorErrorDirective", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The program shall contain no violations of the standard C syntax and constraints, and shall not exceed the implementation\u2019s translation limits", "misra-c2012-1.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Language extensions should not be used", "misra-c2012-1.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("There shall be no occurrence of undefined or critical unspecified behaviour", "misra-c2012-1.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Emergent language features shall not be used", "misra-c2012-1.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("There shall be no dead code", "misra-c2012-2.2", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("A project should not contain unused type declarations", "misra-c2012-2.3", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("A project should not contain unused tag declarations", "misra-c2012-2.4", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("A project should not contain unused macro declarations", "misra-c2012-2.5", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("There should be no unused parameters in functions", "misra-c2012-2.7", "Unused Code"));
        migrations.add(new ConfigurationOptionReplacement("The character sequences /* and // shall not be used within a comment", "misra-c2012-3.1", "Malformed Comments"));
        migrations.add(new ConfigurationOptionReplacement("Line-splicing shall not be used in // comments", "misra-c2012-3.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Octal and hexadecimal escape sequences shall be terminated", "misra-c2012-4.1", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("Trigraphs should not be used", "misra-c2012-4.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("External identifiers shall be distinct", "misra-c2012-5.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Identifiers declared in the same scope and name space shall be distinct", "misra-c2012-5.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Macro identifiers shall be distinct", "misra-c2012-5.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Identifiers shall be distinct from macro names", "misra-c2012-5.5", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A typedef name shall be a unique identifier", "misra-c2012-5.6", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A tag name shall be a unique identifier", "misra-c2012-5.7", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("Identifiers that define objects or functions with external linkage shall be unique", "misra-c2012-5.8", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("Identifiers that define objects or functions with internal linkage should be unique", "misra-c2012-5.9", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("Bit-fields shall only be declared with an appropriate type", "misra-c2012-6.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Single-bit named bit fields shall not be of a signed type", "misra-c2012-6.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Octal constants shall not be used", "misra-c2012-7.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A \u201cu\u201d or \u201cU\u201d suffix shall be applied to all integer constants that are represe", "misra-c2012-7.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The lowercase character \u201cl\u201d shall not be used in a li", "misra-c2012-7.3", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A string literal shall not be assigned to an object unless the object\u2019s type is \u201cpointer to const-qua", "misra-c2012-7.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Types shall be explicitly specified", "misra-c2012-8.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Function types shall be in prototype form with named parameters", "misra-c2012-8.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A compatible declaration shall be visible when an object or function with external linkage is defined", "misra-c2012-8.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("An external object or function shall be declared once in one and only one file", "misra-c2012-8.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("An identifier with external linkage shall have exactly one external definition", "misra-c2012-8.6", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Functions and objects should not be defined with external linkage if they are referenced in only one translation unit", "misra-c2012-8.7", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The static storage class specifier shall be used in all declarations of objects and functions that have internal linkage", "misra-c2012-8.8", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("An object should be defined at block scope if its identifier only appears in a single function", "misra-c2012-8.9", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("An inline function shall be declared with the static storage class", "misra-c2012-8.10", "Runtime Performance"));
        migrations.add(new ConfigurationOptionReplacement("When an array with external linkage is declared, its size should be explicitly specified", "misra-c2012-8.11", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Within an enumerator list, the value of an implicitly-specified enumeration constant shall be unique", "misra-c2012-8.12", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The restrict type qualifier shall not be used", "misra-c2012-8.14", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The value of an object with automatic storage duration shall not be read before it has been set", "misra-c2012-9.1", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The initializer for an aggregate or union shall be enclosed in braces", "misra-c2012-9.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Arrays shall not be partially initialized", "misra-c2012-9.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("An element of an object shall not be initialized more than once", "misra-c2012-9.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Where designated initializers are used to initialize an array object the size of the array shall be specified explicitly", "misra-c2012-9.5", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Operands shall not be of an inappropriate essential type", "misra-c2012-10.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Expressions of essentially character type shall not be used inappropriately in addition and subtraction operations", "misra-c2012-10.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of an expression shall not be assigned to an object with a narrower essential type or of a different essential type category", "misra-c2012-10.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Both operands of an operator in which the usual arithmetic conversions are performed shall have the same essential type category", "misra-c2012-10.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of an expression should not be cast to an inappropriate essential type", "misra-c2012-10.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of a composite expression shall not be assigned to an object with wider essential type", "misra-c2012-10.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("If a composite expression is used as one operand of an operator in which the usual arithmetic conversions are performed then the other operand shall not have wider essential type", "misra-c2012-10.7", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of a composite expression shall not be cast to a different essential type category or a wider essential type", "misra-c2012-10.8", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Conversions shall not be performed between a pointer to a function and any other type", "misra-c2012-11.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Conversions shall not be performed between a pointer to an incomplete type and any other type", "misra-c2012-11.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A cast shall not be performed between a pointer to object type and a pointer to a different object type", "misra-c2012-11.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A conversion should not be performed between a pointer to object and an integer type", "misra-c2012-11.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A conversion should not be performed from pointer to void into pointer to object", "misra-c2012-11.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A cast shall not be performed between pointer to void and an arithmetic type", "misra-c2012-11.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A cast shall not be performed between pointer to object and a non-integer arithmetic type", "misra-c2012-11.7", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A cast shall not remove any const or volatile qualification from the type pointed to by a pointer", "misra-c2012-11.8", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The macro NULL shall be the only permitted form of integer null pointer constant", "misra-c2012-11.9", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The precedence of operators within expressions should be made explicit", "misra-c2012-12.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The right hand operand of a shift operator shall lie in the range zero to one less than the width in bits of the essential type of the left hand operand", "misra-c2012-12.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The comma operator should not be used", "misra-c2012-12.3", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Evaluation of constant expressions should not lead to unsigned integer wrap-around", "misra-c2012-12.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Initializer lists shall not contain persistent side effects", "misra-c2012-13.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A full expression containing an increment (++) or decrement (--) operator should have no other potential side effects other than that caused by the increment or decrement operator", "misra-c2012-13.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The result of an assignment operator should not be used", "misra-c2012-13.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The right hand operand of a logical && or || operator shall not contain persistent side effects", "misra-c2012-13.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The operand of the sizeof operator shall not contain any expression which has potential side effects", "misra-c2012-13.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A loop counter shall not have essentially floating type", "misra-c2012-14.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A for loop shall be well-formed", "misra-c2012-14.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The controlling expression of an if statement and the controlling expression of an iteration-statement shall have essentially Boolean type", "misra-c2012-14.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The goto statement should not be used", "misra-c2012-15.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The goto statement shall jump to a label declared later in the same function", "misra-c2012-15.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Any label referenced by a goto statement shall be declared in the same block, or in any block enclosing the goto statement", "misra-c2012-15.3", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("There should be no more than one break or goto statement used to terminate any iteration statement", "misra-c2012-15.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A function should have a single point of exit at the end", "misra-c2012-15.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The body of an iteration-statement or a selection-statement shall be a compound-statement", "misra-c2012-15.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("All if \u2026 else if constructs shall be terminated with an else state", "misra-c2012-15.7", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("All switch statements shall be well-formed", "misra-c2012-16.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A switch label shall only be used when the most closely-enclosing compound statement is the body of a switch statement", "misra-c2012-16.2", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("An unconditional break statement shall terminate every switch-clause", "misra-c2012-16.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Every switch statement shall have a default label", "misra-c2012-16.4", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A default label shall appear as either the first or the last switch label of a switch statement", "misra-c2012-16.5", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Every switch statement shall have at least two switch-clauses", "misra-c2012-16.6", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A switch-expression shall not have essentially Boolean type", "misra-c2012-16.7", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The features of <stdarg.h> shall not be used", "misra-c2012-17.1", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("Functions shall not call themselves, either directly or indirectly", "misra-c2012-17.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A function shall not be declared implicitly", "misra-c2012-17.3", "Design Flaws"));
        migrations.add(new ConfigurationOptionReplacement("The declaration of an array parameter shall not contain the static keyword between the [ ]", "misra-c2012-17.6", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The value returned by a function having non-void return type shall be used", "misra-c2012-17.7", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A function parameter should not be modified", "misra-c2012-17.8", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Subtraction between pointers shall only be applied to pointers that address elements of the same array", "misra-c2012-18.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The relational operators >, >=, < and <= shall not be applied to objects of pointer type except where they point into the same object", "misra-c2012-18.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The +, -, += and -= operators should not be applied to an expression of pointer type", "misra-c2012-18.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Declarations should contain no more than two levels of pointer nesting", "misra-c2012-18.5", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The address of an object with automatic or thread-local storage shall not be copied to another object that persists after the first object has ceased to exist", "misra-c2012-18.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Flexible array members shall not be declared", "misra-c2012-18.7", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("Variable-length array types shall not be used", "misra-c2012-18.8", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("An object shall not be assigned or copied to an overlapping object", "misra-c2012-19.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The union keyword should not be used", "misra-c2012-19.2", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("#include directives should only be preceded by preprocessor directives or comments", "misra-c2012-20.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("\"The ', \"\" or \\ characters and the /* or // character sequences shall not occur in a header file name\"", "misra-c2012-20.2", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("\"The #include directive shall be followed by either a <filename> or \"\"filename\"\" sequence\"", "misra-c2012-20.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A macro shall not be defined with the same name as a keyword", "misra-c2012-20.4", "Naming"));
        migrations.add(new ConfigurationOptionReplacement("#undef should not be used", "misra-c2012-20.5", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Tokens that look like a preprocessing directive shall not occur within a macro argument", "misra-c2012-20.6", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("Expressions resulting from the expansion of macro parameters shall be enclosed in parentheses", "misra-c2012-20.7", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The controlling expression of a #if or #elif preprocessing directive shall evaluate to 0 or 1", "misra-c2012-20.8", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("All identifiers used in the controlling expression of #if or #elif preprocessing directives shall be #define'd before evaluation", "misra-c2012-20.9", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The # and ## preprocessor operators should not be used", "misra-c2012-20.10", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A macro parameter immediately following a # operator shall not immediately be followed by a ## operator", "misra-c2012-20.11", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A macro parameter used as an operand to the # or ## operators, which is itself subject to further macro replacement, shall only be used as an operand to these operators", "misra-c2012-20.12", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A line whose first token is # shall be a valid preprocessing directive", "misra-c2012-20.13", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("All #else, #elif and #endif preprocessor directives shall reside in the same file as the #if, #ifdef or #ifndef directive to which they are related", "misra-c2012-20.14", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("#define and #undef shall not be used on a reserved identifier or reserved macro name", "misra-c2012-21.1", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("A reserved identifier or reserved macro name shall not be declared", "misra-c2012-21.2", "Possible Bugs"));
        migrations.add(new ConfigurationOptionReplacement("The memory allocation and deallocation functions of <stdlib.h> shall not be used", "misra-c2012-21.3", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The standard header file <setjmp.h> shall not be used", "misra-c2012-21.4", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The standard header file <signal.h> shall not be used", "misra-c2012-21.5", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library input/output functions shall not be used", "misra-c2012-21.6", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library functions atof, atoi, atol and atoll of <stdlib.h> shall not be used", "misra-c2012-21.7", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library functions abort, exit and system of <stdlib.h> shall not be used", "misra-c2012-21.8", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library functions bsearch and qsort of <stdlib.h> shall not be used", "misra-c2012-21.9", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library time and date functions shall not be used", "misra-c2012-21.10", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The standard header file <tgmath.h> shall not be used", "misra-c2012-21.11", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The exception handling features of <fenv.h> should not be used", "misra-c2012-21.12", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("Any value passed to a function in <ctype.h> shall be representable as an unsigned char or be the value EOF", "misra-c2012-21.13", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library function memcmp shall not be used to compare null terminated strings", "misra-c2012-21.14", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The pointer arguments to the Standard Library functions memcpy, memmove and memcmp shall be pointers to qualified or unqualified versions of compatible types", "misra-c2012-21.15", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The pointer arguments to the Standard Library function memcmp shall point to either a pointer type, an essentially signed type, an essentially unsigned type, an essentially Boolean type or an essentially enum type", "misra-c2012-21.16", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("Use of the string handling functions from <string.h> shall not result in accesses beyond the bounds of the objects referenced by their pointer parameters", "misra-c2012-21.17", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The size_t argument passed to any function in <string.h> shall have an appropriate value", "misra-c2012-21.18", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The pointers returned by the Standard Library functions localeconv, getenv, setlocale or, strerror shall only be used as if they have pointer to const-qualified type", "misra-c2012-21.19", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The pointer returned by the Standard Library functions asctime, ctime, gmtime, localtime, localeconv, getenv, setlocale or strerror shall not be used following a subsequent call to the same function", "misra-c2012-21.20", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("The Standard Library function system of <stdlib.h> shall not be used", "misra-c2012-21.21", "Discouraged APIs"));
        migrations.add(new ConfigurationOptionReplacement("All resources obtained dynamically by means of Standard Library functions shall be explicitly release", "misra-c2012-22.1", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A block of memory shall only be freed if it was allocated by means of a Standard Library function", "misra-c2012-22.2", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The same file shall not be open for read and write access at the same time on different streams", "misra-c2012-22.3", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("There shall be no attempt to write to a stream which has been opened as read-only", "misra-c2012-22.4", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("A pointer to a FILE object shall not be dereferenced", "misra-c2012-22.5", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of a pointer to a FILE shall not be used after the associated stream has been closed", "misra-c2012-22.6", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The macro EOF shall only be compared with the unmodified return value from any Standard Library function capable of returning EOF", "misra-c2012-22.7", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of errno shall be set to zero prior to a call to an errno-setting-function", "misra-c2012-22.8", "Error-prone Practices"));
        migrations.add(new ConfigurationOptionReplacement("The value of errno shall be tested against zero after calling an errno-setting-function", "misra-c2012-22.9", "Bad Practice"));
        migrations.add(new ConfigurationOptionReplacement("The value of errno shall only be tested when the last function to be called was an errno-setting-function", "misra-c2012-22.10", "Bad Practice"));
        return migrations;
    }
}

