/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.ServiceUtils;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import java.io.Serializable;
import java.util.Optional;
import java.util.StringJoiner;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MetricSchemaChangeEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String METRIC_ID_PROPERTY = "metricId";
    private static final String ANALYSIS_GROUP_PROPERTY = "analysisGroup";
    private static final String METRIC_DEFINITION_PROPERTY = "metricDefinition";
    @JsonProperty(value="metricId")
    private final String metricId;
    @JsonProperty(value="analysisGroup")
    private final String analysisGroup;
    @JsonProperty(value="metricDefinition")
    private final MetricDirectorySchemaEntry metricDefinition;

    @JsonCreator
    public MetricSchemaChangeEntry(@JsonProperty(value="metricId") String metricId, @JsonProperty(value="analysisGroup") String analysisGroup, @JsonProperty(value="metricDefinition") MetricDirectorySchemaEntry metricDefinition) {
        this.metricId = metricId;
        this.analysisGroup = analysisGroup;
        this.metricDefinition = metricDefinition;
    }

    public String toString() {
        return "MetricSchemaChangeEntry [metricId=" + this.metricId + ", analysisGroup=" + this.analysisGroup + ", metricDirectoryEntry=" + String.valueOf(this.metricDefinition) + "]";
    }

    public String getMetricId() {
        return this.metricId;
    }

    public String getAnalysisGroup() {
        return this.analysisGroup;
    }

    public MetricDirectorySchemaEntry getMetricDirectoryEntry() {
        return this.metricDefinition;
    }

    public int hashCode() {
        return this.metricId.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetricSchemaChangeEntry)) {
            return false;
        }
        return this.metricId.equals(((MetricSchemaChangeEntry)other).metricId);
    }

    public Optional<String> validateIdentifiers() {
        StringJoiner errorMessageJoiner = new StringJoiner(", ");
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getMetricId(), (String)"Metric id").ifPresent(errorMessageJoiner::add);
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getMetricDirectoryEntry().getName(), (String)"Metric name").ifPresent(errorMessageJoiner::add);
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getAnalysisGroup(), (String)"Analysis group name").ifPresent(errorMessageJoiner::add);
        if (errorMessageJoiner.length() > 0) {
            return Optional.of(errorMessageJoiner.toString() + ".");
        }
        return Optional.empty();
    }
}

